/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.ClientUtil;
import amazon.emr.metrics.MetricsConfig;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsSaver
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(MetricsSaver.class);
    protected MetricsConfig config;
    protected String metricFile;
    protected HashMap<String, MetricProtos.EmrMetricRecord.Builder> records;
    protected FileOutputStream fileOutput;
    protected static volatile MetricsSaver instance = null;
    private static final Lock instanceLock = new ReentrantLock();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new DaemonThreadFactory());
    private SystemMetricProducer systemProducer;
    private boolean needEnsureDir;
    private String processName;
    public final int pid;
    protected static boolean metricsDisabledInCluster = false;
    private Boolean shutdownComplete;
    protected boolean emrClusterStarted = false;
    protected boolean emrClusterMapR = false;
    protected StopWatch waitClusterStartWatch = new StopWatch();
    private StopWatch lastFlushWatch = new StopWatch();
    protected MetricProtos.EmrMetricsConfigRecord configRecord = null;
    public static int SAVER_BASE_INTERVAL_SEC = 30;
    protected static int initialize_failure_count = 0;
    protected static final int INITIALIZE_ATTEMPT_MAX = 10;
    private ArrayList<MetricsLockFreeSaver> lockFreeSavers = new ArrayList();
    private String idstr;
    static long totalLockWaitMills = 0L;
    static long totalLockWaitCount = 0L;
    static long firstWaitBeginTime = 0L;
    static long currLockMeasureWindow = 0L;
    static int compactTraceCount = 0;
    static final int MAX_VALUES_DENSITY = 50;
    static AtomicInteger lockFreeSaverId = new AtomicInteger();

    public static void initialize(MetricsConfig config) throws Exception {
        MetricsSaver.ensureSingleton(config);
    }

    public static void initialize() throws Exception {
        MetricsSaver.ensureSingleton(null);
    }

    public static void initializeNoThrow() {
        MetricsSaver.initializeNoThrow(null);
    }

    public static void initializeNoThrow(MetricsConfig config) {
        try {
            if (instance == null) {
                logger.info("About to initialize MetricsSaver");
            }
            MetricsSaver.ensureSingleton(config);
        }
        catch (Exception e) {
            if (++initialize_failure_count == 10) {
                MetricsConfig.disableMetricSaver = true;
                logger.info("disableMetricSaver due to repeating initialization error ", (Throwable)e);
            }
            logger.info("Failed to initialize MetricsSaver {}", (Object)e.getMessage());
        }
    }

    public static MetricsSaver singleton() throws Exception {
        MetricsSaver.ensureSingleton(null);
        return instance;
    }

    public static void addValue(String key, long value) {
        MetricsSaver.addInternal(key, value, null, null);
    }

    public static void addValue(String key, long value, String context) {
        MetricsSaver.addInternal(key, value, null, context);
    }

    public static void addError(String key, String error) {
        MetricsSaver.addInternal(key, null, error, null);
    }

    public static void addError(String key, String error, String context) {
        MetricsSaver.addInternal(key, null, error, context);
    }

    public static void addValueWithError(String key, long value, String error) {
        MetricsSaver.addInternal(key, value, error, null);
    }

    public static void addValueWithError(String key, long value, Exception e) {
        MetricsSaver.addInternal(key, value, e.getClass().toString(), null);
    }

    public static void addValueWithError(String key, long value, String error, String context) {
        MetricsSaver.addInternal(key, value, error, context);
    }

    protected MetricsSaver(MetricsConfig config) throws Exception {
        this.config = config;
        this.fileOutput = null;
        this.processName = config.processName.replace(':', '_');
        if (this.processName == null || this.processName.isEmpty()) {
            this.processName = ClientUtil.getProcessMainClassName(true);
        }
        if (this.processName == null) {
            this.processName = ClientUtil.getPidStr();
        }
        this.pid = ClientUtil.getPid();
        this.metricFile = this.getDailyMetricsFilePath(config);
        this.records = new HashMap();
        this.systemProducer = new SystemMetricProducer();
        if (config.saverPeriodSec > 0) {
            this.scheduler.scheduleAtFixedRate(this, SAVER_BASE_INTERVAL_SEC, SAVER_BASE_INTERVAL_SEC, TimeUnit.SECONDS);
        }
        if (MetricsConfig.systemProducerPeriodSec > 0) {
            this.scheduler.scheduleAtFixedRate(this.systemProducer, 45L, MetricsConfig.systemProducerPeriodSec, TimeUnit.SECONDS);
        }
        this.needEnsureDir = true;
        metricsDisabledInCluster = false;
        if (!config.hdfs) {
            this.configRecord = MetricsSaver.readLocalMetricsConfigFile();
            boolean bl = metricsDisabledInCluster = this.configRecord == null || this.configRecord.getDisabledInCluster();
            if (!MetricsConfig.disableMetricSaver) {
                MetricsSaver.showConfigRecord(this.configRecord);
            }
            if (this.configRecord == null) {
                // empty if block
            }
        } else {
            metricsDisabledInCluster = false;
        }
        this.shutdownComplete = false;
        this.idstr = String.format("%s:%s:%s:%05d", config.jobFlowId, config.instanceId, this.processName, this.pid);
        if (!MetricsConfig.disableMetricSaver) {
            logger.info("Created MetricsSaver {} period:{} {}", new Object[]{this.idstr, config.saverPeriodSec, this.metricFile});
        }
    }

    public String getDailyMetricsFilePath(MetricsConfig config) {
        Date now = new Date();
        String dateStr = new SimpleDateFormat("yyyyMMdd").format(now);
        String baseFileName = String.format("%s_%s_%s_%05d_raw.bin", config.instanceId, dateStr.replace(' ', '0'), this.processName, this.pid);
        return new File(config.rawDir, baseFileName).getPath();
    }

    public void run() {
        try {
            if (this.config.hdfs && this.lastFlushWatch.elapsedSeconds() < (long)(this.config.saverPeriodSec - 2)) {
                return;
            }
            this.flush(true);
            this.lastFlushWatch.reset();
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInternal(String key, Long value, String error, String context) {
        int maxErrorLength = 64;
        if (MetricsConfig.disableMetricSaver || metricsDisabledInCluster) {
            return;
        }
        try {
            key = MetricsSaver.sanitizeKey(key);
            context = MetricsSaver.sanitizeContext(context);
            String simpleError = MetricsSaver.truncateError(error, 64);
            MetricsSaver.ensureSingleton(null);
            long waitBeginTime = 0L;
            if (MetricsConfig.saverLockDelayMeasureWindow > 0L) {
                waitBeginTime = System.currentTimeMillis();
            }
            MetricsSaver metricsSaver = instance;
            synchronized (metricsSaver) {
                if (firstWaitBeginTime == 0L) {
                    firstWaitBeginTime = waitBeginTime;
                }
                if (MetricsConfig.saverLockDelayMeasureWindow > 0L) {
                    long currTime = System.currentTimeMillis();
                    long windows = currTime / MetricsConfig.saverLockDelayMeasureWindow;
                    if (currLockMeasureWindow == 0L) {
                        currLockMeasureWindow = windows;
                    }
                    long elapseTime = currTime - firstWaitBeginTime;
                    totalLockWaitMills += currTime - waitBeginTime;
                    ++totalLockWaitCount;
                    if (windows != currLockMeasureWindow) {
                        double fraction = (double)totalLockWaitMills / (double)elapseTime;
                        logger.info(String.format("SaverLock count %d WaitMs %d elapse %d ratio %4.3f", totalLockWaitCount, totalLockWaitMills, elapseTime, fraction));
                        currLockMeasureWindow = windows;
                        firstWaitBeginTime = 0L;
                        totalLockWaitCount = 0L;
                        totalLockWaitMills = 0L;
                    }
                }
                MetricProtos.EmrMetricRecord.Builder rb = instance.getMetricRecord(key);
                MetricsSaver.addRecordValue(rb, value, simpleError, context);
            }
        }
        catch (Exception e) {
            logger.info("add metric {}", (Throwable)e);
        }
    }

    public static String sanitizeKey(String key) {
        if ((key = key.replace(':', '_')).length() > 48) {
            key = key.substring(0, 48);
        }
        return key;
    }

    public static String sanitizeContext(String context) {
        if (context != null && context.length() > 64) {
            context = context.substring(0, 64);
        }
        return context;
    }

    private static String truncateError(String error, int maxLen) {
        if (error == null || error.length() <= maxLen) {
            return error;
        }
        String e = error.substring(0, maxLen);
        int index = e.lastIndexOf(32, maxLen >> 1);
        return index > 0 ? e.substring(0, index) + " ..." : e;
    }

    protected MetricProtos.EmrMetricRecord.Builder getMetricRecord(String key) {
        MetricProtos.EmrMetricRecord.Builder rb = null;
        rb = this.records.get(key);
        if (rb != null) {
            return rb;
        }
        rb = MetricProtos.EmrMetricRecord.newBuilder();
        MetricProtos.EmrMetricKey.Builder kb = MetricProtos.EmrMetricKey.newBuilder();
        kb.setInstanceId(this.config.instanceId);
        kb.setProcess(this.processName);
        kb.setKey(key);
        kb.setInterval(0);
        kb.setPid(this.pid);
        rb.setKey(kb);
        this.records.put(key, rb);
        return rb;
    }

    protected static void addRecordValue(MetricProtos.EmrMetricRecord.Builder rb, Long value, String error, String context) throws Exception {
        MetricProtos.EmrMetricRawValue.Builder vb = MetricProtos.EmrMetricRawValue.newBuilder();
        vb.setTime(System.currentTimeMillis());
        if (value != null) {
            vb.setValue(value);
        }
        if (error != null) {
            vb.setError(error);
        }
        if (context != null) {
            vb.setContext(context);
        }
        MetricsSaver.compactRawValues(rb, vb.getTime());
        rb.addValues(vb);
    }

    protected static void compactRawValues(MetricProtos.EmrMetricRecord.Builder rb, long newTime) {
        int n = rb.getValuesCount();
        if (n < 50) {
            return;
        }
        long lastTime = rb.getValues(n - 1).getTime();
        if (newTime / 1000L <= lastTime / 1000L) {
            return;
        }
        long firstTime = rb.getValues(0).getTime() / 1000L;
        int durSec = (int)((lastTime - firstTime) / 1000L);
        if (n < durSec * 50) {
            return;
        }
        List<MetricProtos.EmrMetricAggregatedValue> aggValues = ClientUtil.aggregateRawValues(rb.getValuesList());
        rb.clearValues();
        rb.addAllValuesEx(aggValues);
        if (++compactTraceCount % 100 == 1) {
            String message = String.format("%d aggregated %s %d raw values into %d aggregated values, total %d", compactTraceCount, rb.getKey().getKey(), n, aggValues.size(), rb.getValuesExCount());
            logger.info(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(boolean withRetry) throws Exception {
        boolean shouldFlush = this.checkShouldFlush();
        if (!shouldFlush) {
            return;
        }
        ArrayList<MetricProtos.EmrMetricRecord.Builder> recordsToSave = new ArrayList<MetricProtos.EmrMetricRecord.Builder>();
        MetricsSaver metricsSaver = this;
        synchronized (metricsSaver) {
            recordsToSave.addAll(this.records.values());
            this.records = new HashMap();
            Iterator<MetricsLockFreeSaver> it = this.lockFreeSavers.iterator();
            while (it.hasNext()) {
                MetricsLockFreeSaver f = it.next();
                f.commitIdleValues();
                if (f.closed || System.currentTimeMillis() - f.lastVisitTime > 3600000L) {
                    it.remove();
                    f.removed = true;
                    if (!f.closed) {
                        logger.info("removed idle MetricsLockFreeSaver {} from thread {}", (Object)f.id, (Object)f.threadId);
                    }
                }
                recordsToSave.addAll(f.takeAllCommitted().values());
            }
        }
        if (recordsToSave.isEmpty()) {
            return;
        }
        Vector<MetricProtos.EmrMetricRecord> records = new Vector<MetricProtos.EmrMetricRecord>();
        for (MetricProtos.EmrMetricRecord.Builder rb : recordsToSave) {
            records.add(rb.build());
        }
        String metricFileNew = this.getDailyMetricsFilePath(this.config);
        if (!metricFileNew.equals(this.metricFile)) {
            logger.info("MetricsSaver {} metricFile {}", (Object)this.idstr, (Object)this.metricFile);
            this.metricFile = metricFileNew;
        }
        int[] retries = new int[]{0, 1000, 2000, 4000, 8000};
        for (int i = 0; i < retries.length; ++i) {
            StopWatch w = new StopWatch();
            try {
                if (this.needEnsureDir) {
                    this.ensureDirs();
                    this.needEnsureDir = false;
                }
                if (retries[i] != 0) {
                    Thread.sleep(retries[i]);
                }
                this.openOutputStream(false);
                w.reset();
                int count = records.size();
                int valueCount = 0;
                while (records.size() > 0) {
                    MetricProtos.EmrMetricRecord r = (MetricProtos.EmrMetricRecord)records.firstElement();
                    MetricProtos.EmrMetricRecord r2 = ClientUtil.aggregateRawValues(r, 50);
                    this.writeRecord(r2);
                    valueCount += r2.getValuesCount() + r2.getValuesExCount();
                    records.remove(0);
                }
                this.closeOutputStream();
                break;
            }
            catch (IllegalStateException ex) {
                break;
            }
            catch (Exception e) {
                logger.error("Failed SaveRecords {} {}", (Object)this.metricFile, (Object)e.getMessage());
                if (withRetry) continue;
                break;
            }
            finally {
                this.closeOutputStream();
                MetricsSaver.addValue("MetricsFlushDelay", w.elapsedTime());
            }
        }
        if (records.size() != 0) {
            logger.info("Discard {} records", (Object)records.size());
        }
    }

    protected void writeRecord(MetricProtos.EmrMetricRecord r) throws IOException {
        r.writeDelimitedTo(this.fileOutput);
    }

    protected void ensureDirs() throws IOException {
        MetricsSaver.ensureLocalDir(this.config.rootDir);
        MetricsSaver.ensureLocalDir(this.config.rawDir);
    }

    protected void openOutputStream(boolean forceReopen) throws IOException {
        if (this.config.hdfs) {
            throw new RuntimeException("Unexpected HDFS destination");
        }
        if (forceReopen) {
            this.closeOutputStream();
        }
        if (this.fileOutput != null) {
            return;
        }
        this.fileOutput = new FileOutputStream(this.metricFile, true);
    }

    protected void closeOutputStream() {
        if (this.fileOutput != null) {
            try {
                this.fileOutput.close();
            }
            catch (IOException ex) {
                logger.info("Failed to close output stream ", (Object)ex.getMessage());
            }
        }
        this.fileOutput = null;
    }

    protected boolean checkShouldFlush() {
        boolean disabledInCluster;
        block8: {
            if (MetricsConfig.disableMetricSaver) {
                return false;
            }
            disabledInCluster = metricsDisabledInCluster;
            try {
                MetricProtos.EmrMetricsConfigRecord r = MetricsSaver.readLocalMetricsConfigFile();
                if (r != null && (this.configRecord == null || this.configRecord.hashCode() != r.hashCode())) {
                    MetricsSaver.showConfigRecord(r);
                    disabledInCluster = r.getDisabledInCluster();
                    this.configRecord = r;
                }
            }
            catch (Exception e) {
                logger.info("readMetricsConfigFile failed {} ", (Object)this.config.emrMetricsConfigFile, (Object)e);
                if (this.records.size() <= 0) break block8;
                logger.info("Give up {} records waiting for config file", (Object)this.records.size());
                this.records.clear();
            }
        }
        if (disabledInCluster != metricsDisabledInCluster) {
            metricsDisabledInCluster = disabledInCluster;
            logger.info("EMR metrics is {}abled", (Object)(disabledInCluster ? "dis" : "en"));
        } else if (this.configRecord == null) {
            // empty if block
        }
        if (this.records.isEmpty()) {
            return false;
        }
        return !disabledInCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MetricProtos.EmrMetricsConfigRecord readLocalMetricsConfigFile() {
        String filename = "/mnt/var/em/emr-metrics-config.bin";
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInput = null;
        try {
            if (filename.endsWith(".txt")) {
                MetricProtos.EmrMetricsConfigRecord.Builder rb = MetricProtos.EmrMetricsConfigRecord.newBuilder();
                String content = ClientUtil.readFileAsString(filename);
                if (content != null && !content.isEmpty()) {
                    TextFormat.merge((CharSequence)content, (Message.Builder)rb);
                    MetricProtos.EmrMetricsConfigRecord emrMetricsConfigRecord = rb.build();
                    return emrMetricsConfigRecord;
                }
                MetricProtos.EmrMetricsConfigRecord emrMetricsConfigRecord = null;
                return emrMetricsConfigRecord;
            }
            fileInput = new FileInputStream(filename);
            MetricProtos.EmrMetricsConfigRecord rb = MetricProtos.EmrMetricsConfigRecord.parseDelimitedFrom(fileInput);
            return rb;
        }
        catch (Exception ex) {
            logger.info("Read EmrMetricsConfigRecord {} error : ", (Object)filename, (Object)ex);
            MetricProtos.EmrMetricsConfigRecord emrMetricsConfigRecord = null;
            return emrMetricsConfigRecord;
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void showConfigRecord(MetricProtos.EmrMetricsConfigRecord r) {
        if (r != null) {
            String v = TextFormat.printToString((MessageOrBuilder)r).replace('\n', ' ');
            logger.info("MetricsConfigRecord {}", (Object)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureSingleton(MetricsConfig config) throws Exception {
        if (instance != null) return;
        Class<MetricsSaver> clazz = MetricsSaver.class;
        synchronized (MetricsSaver.class) {
            MetricsSaver s;
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (config == null) {
                config = new MetricsConfig(false);
            }
            instance = s = new MetricsSaver(config);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    MetricsSaver.shutdown();
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performShutdown() {
        try {
            Boolean bl = this.shutdownComplete;
            synchronized (bl) {
                if (!this.shutdownComplete.booleanValue()) {
                    instance.flush(false);
                    this.shutdownComplete = true;
                }
            }
        }
        catch (IllegalStateException ex) {
            logger.info("Error while flushing {}", (Object)ex.getMessage());
        }
        catch (Exception e) {
            logger.info("Error while flushing", (Throwable)e);
        }
    }

    public static void shutdown() {
        if (instance != null) {
            instance.performShutdown();
        }
    }

    public static void ensureLocalDir(String dir) throws IOException {
        boolean success = false;
        File file = new File(dir);
        if (!file.exists()) {
            MetricsSaver.ensureLocalDir(file.getParent());
            success = file.mkdir();
            if (!success) {
                logger.info("mkdir {} {}", (Object)dir, (Object)success);
            }
        }
    }

    private synchronized void registerFastSaver(MetricsLockFreeSaver fastSaver) {
        this.lockFreeSavers.add(fastSaver);
    }

    public static MetricsLockFreeSaver createLockFreeSaver() {
        try {
            MetricsSaver.ensureSingleton(null);
            MetricsLockFreeSaver f = new MetricsLockFreeSaver();
            instance.registerFastSaver(f);
            return f;
        }
        catch (Exception ex) {
            logger.info("Failed to create MetricsLockFreeSaver ", (Throwable)ex);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetricsLockFreeSaver {
        static final long COMMIT_INTERVAL_MILLS = 1000L;
        private HashMap<String, SimpleAccumulator> pending;
        private HashMap<String, List<SimpleAccumulator>> committed;
        private HashMap<String, Long> lastVisitTimes;
        protected long lastVisitTime = System.currentTimeMillis();
        protected boolean closed = false;
        protected boolean removed = false;
        public final int id;
        public final long threadId;
        static AtomicInteger traceCounter = new AtomicInteger();

        protected MetricsLockFreeSaver() throws Exception {
            this.pending = new HashMap();
            this.committed = new HashMap();
            this.lastVisitTimes = new HashMap();
            this.id = lockFreeSaverId.incrementAndGet();
            this.threadId = Thread.currentThread().getId();
            if (!MetricsConfig.disableMetricSaver && this.id % 500 == 1) {
                logger.info("Thread {} created MetricsLockFreeSaver {}", (Object)this.threadId, (Object)this.id);
            }
        }

        public synchronized void close() {
            for (String key : this.pending.keySet()) {
                SimpleAccumulator p = this.pending.get(key);
                List<SimpleAccumulator> cms = this.committed.get(key);
                if (cms == null) {
                    cms = new ArrayList<SimpleAccumulator>();
                    this.committed.put(key, cms);
                }
                cms.add(p);
            }
            this.pending.clear();
            this.closed = true;
        }

        protected synchronized HashMap<String, MetricProtos.EmrMetricRecord.Builder> takeAllCommitted() {
            HashMap<String, List<SimpleAccumulator>> all = this.committed;
            this.committed = new HashMap();
            HashMap<String, MetricProtos.EmrMetricRecord.Builder> output = new HashMap<String, MetricProtos.EmrMetricRecord.Builder>();
            for (Map.Entry<String, List<SimpleAccumulator>> entry : all.entrySet()) {
                List<SimpleAccumulator> accumulators = entry.getValue();
                if (accumulators.size() == 0) continue;
                MetricProtos.EmrMetricRecord.Builder rb = MetricProtos.EmrMetricRecord.newBuilder();
                rb.setKey(accumulators.get((int)0).key);
                for (SimpleAccumulator a : accumulators) {
                    rb.addValuesEx(a.aggregate());
                }
                output.put(entry.getKey(), rb);
            }
            return output;
        }

        protected synchronized HashMap<String, MetricProtos.EmrMetricRecord.Builder> takeAllPending() {
            HashMap<String, SimpleAccumulator> all = this.pending;
            this.pending = new HashMap();
            HashMap<String, MetricProtos.EmrMetricRecord.Builder> output = new HashMap<String, MetricProtos.EmrMetricRecord.Builder>();
            for (Map.Entry<String, SimpleAccumulator> entry : all.entrySet()) {
                MetricProtos.EmrMetricRecord.Builder rb = MetricProtos.EmrMetricRecord.newBuilder();
                rb.setKey(entry.getValue().key);
                rb.addValuesEx(entry.getValue().aggregate());
                output.put(entry.getKey(), rb);
            }
            return output;
        }

        public void addValue(String key, long value) {
            this.addInternal(key, value, null, null);
        }

        public void addValueWithError(String key, long value, String error) {
            this.addInternal(key, value, error, null);
        }

        public void addValueWithError(String key, long value, Exception e) {
            this.addInternal(key, value, e.getClass().toString(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addInternal(String key, Long value, String error, String context) {
            int maxErrorLength = 64;
            if (MetricsConfig.disableMetricSaver || metricsDisabledInCluster) {
                return;
            }
            if (this.closed || this.removed) {
                return;
            }
            try {
                key = MetricsSaver.sanitizeKey(key);
                context = MetricsSaver.sanitizeContext(context);
                String simpleError = MetricsSaver.truncateError(error, 64);
                SimpleAccumulator a = this.pending.get(key);
                long now = System.currentTimeMillis();
                if (a != null && a.startTime < now - 1000L) {
                    MetricsLockFreeSaver metricsLockFreeSaver = this;
                    synchronized (metricsLockFreeSaver) {
                        this.commitPendingKey(key);
                        a = null;
                    }
                }
                if (a == null) {
                    a = new SimpleAccumulator(key);
                    this.pending.put(key, a);
                }
                a.addValue(value, simpleError, context);
                this.lastVisitTime = now;
                this.lastVisitTimes.put(key, this.lastVisitTime);
            }
            catch (Exception e) {
                logger.info("add metric {} {}", (Object)key, (Object)e.getMessage());
            }
        }

        protected synchronized void commitIdleValues() {
            try {
                long now = System.currentTimeMillis();
                long cutoff = now - now % 1000L - 10000L;
                for (Map.Entry<String, Long> entry : this.lastVisitTimes.entrySet()) {
                    String key = entry.getKey();
                    long value = entry.getValue();
                    if (value >= cutoff) continue;
                    this.commitPendingKey(key);
                }
            }
            catch (Exception ex) {
                logger.info("commitAll error {}", (Object)ex.getMessage(), (Object)ex);
            }
        }

        private void commitPendingKey(String key) {
            SimpleAccumulator a = this.pending.get(key);
            if (a == null) {
                return;
            }
            List<SimpleAccumulator> v = this.committed.get(key);
            if (v == null) {
                v = new ArrayList<SimpleAccumulator>();
                this.committed.put(key, v);
            }
            v.add(a);
            int traceCount = traceCounter.incrementAndGet();
            if (traceCount % 1000 == 1) {
                logger.info("{} MetricsLockFreeSaver {} comitted {} matured {} values", new Object[]{traceCount, this.id, a.valueCount, key});
            }
            this.pending.remove(a);
        }

        static class SimpleAccumulator {
            MetricProtos.EmrMetricKey key;
            long startTime;
            long valueSum;
            int valueCount;
            long valueMax;
            String errorStr;
            int errorCount;

            public SimpleAccumulator(String key) {
                MetricProtos.EmrMetricKey.Builder kb = MetricProtos.EmrMetricKey.newBuilder();
                kb.setInstanceId(MetricsSaver.instance.config.instanceId);
                kb.setProcess(instance.processName);
                kb.setKey(key);
                kb.setInterval(0);
                this.key = kb.build();
                long now = System.currentTimeMillis();
                this.startTime = now - now % 1000L;
                this.valueSum = 0L;
                this.valueCount = 0;
                this.valueMax = 0L;
                this.errorStr = null;
                this.errorCount = 0;
            }

            public MetricProtos.EmrMetricAggregatedValue aggregate() {
                MetricProtos.EmrMetricAggregatedValue.Builder vb = MetricProtos.EmrMetricAggregatedValue.newBuilder();
                vb.setCount(this.valueCount);
                vb.setStart(this.startTime);
                vb.setStop(this.startTime + 1000L);
                vb.setSum(this.valueSum);
                if (this.valueCount > 0) {
                    vb.setAverage(this.valueSum / (long)this.valueCount);
                    double v = this.valueMax;
                    vb.setTp90(v * 0.9);
                }
                if (this.errorStr != null) {
                    MetricProtos.EmrMetricErrorItem.Builder b = MetricProtos.EmrMetricErrorItem.newBuilder();
                    b.setError(this.errorStr);
                    b.setCount(this.errorCount);
                    vb.addErrors(b);
                }
                return vb.build();
            }

            public void addValue(long value, String error, String context) {
                if (this.valueMax < value) {
                    this.valueMax = value;
                }
                this.valueSum += value;
                ++this.valueCount;
                if (error != null) {
                    if (this.errorStr == null) {
                        this.errorStr = error;
                    }
                    ++this.errorCount;
                }
            }
        }
    }

    static class SystemMetricProducer
    implements Runnable {
        private MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        private List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

        SystemMetricProducer() {
        }

        public void run() {
            MetricsSaver.addValue("DaemonThreadCount", this.threadBean.getDaemonThreadCount());
            MetricsSaver.addValue("ThreadCount", this.threadBean.getThreadCount());
            MemoryUsage memoryUsage = this.memoryBean.getHeapMemoryUsage();
            MetricsSaver.addValue("HeapMemoryUsage", memoryUsage.getUsed());
            MetricsSaver.addValue("HeapMemoryMax", memoryUsage.getMax());
            MetricsSaver.addValue("HeapMemoryCommitted", memoryUsage.getCommitted());
            long collectionTime = 0L;
            long collectionCount = 0L;
            for (GarbageCollectorMXBean gcBean : this.gcBeans) {
                long t = gcBean.getCollectionTime();
                long c = gcBean.getCollectionCount();
                if (t >= 0L) {
                    collectionTime += t;
                }
                if (c < 0L) continue;
                collectionCount += c;
            }
            MetricsSaver.addValue("GCTime", collectionTime);
            MetricsSaver.addValue("GCCount", collectionCount);
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static class StopWatch {
        long start;
        long stop;
        boolean stopped;

        public StopWatch() {
            this.reset();
        }

        public void reset() {
            this.start = System.currentTimeMillis();
            this.stopped = false;
            this.stop = 0L;
        }

        public void stop() {
            this.stopped = true;
            this.stop = System.currentTimeMillis();
        }

        public long elapsedTime() {
            return this.stopped ? this.stop - this.start : System.currentTimeMillis() - this.start;
        }

        public long elapsedSeconds() {
            return this.elapsedTime() / 1000L;
        }
    }
}

