/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ErrorMap {
    static final Logger logger = LoggerFactory.getLogger(ErrorMap.class);
    static final int MaxDistinctErrorCount = 32;
    HashMap<String, Integer> errorMap = new HashMap();
    int totalCount = 0;
    static final Comparator<Map.Entry<String, Integer>> COMPARATOR = new Comparator<Map.Entry<String, Integer>>(){

        @Override
        public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
            return o2.getValue() - o1.getValue();
        }
    };

    public ErrorMap() {
    }

    public ErrorMap(List<MetricProtos.EmrMetricErrorItem> errors) {
        this.add(errors);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void add(String error, int count) {
        this.totalCount += count;
        Integer c = this.errorMap.get(error);
        this.errorMap.put(error, c == null ? count : c + count);
    }

    public void add(List<MetricProtos.EmrMetricErrorItem> errors) {
        for (MetricProtos.EmrMetricErrorItem t : errors) {
            this.add(t.getError(), t.getCount());
        }
    }

    public void add(MetricProtos.EmrMetricRecord r) {
        if (r.getValuesCount() > 0) {
            for (MetricProtos.EmrMetricRawValue v : r.getValuesList()) {
                if (!v.hasError()) continue;
                this.add(v.getError(), 1);
            }
        } else {
            for (MetricProtos.EmrMetricAggregatedValue v : r.getValuesExList()) {
                this.add(v.getErrorsList());
            }
        }
    }

    public void export(MetricProtos.EmrMetricAggregatedValue.Builder vb) {
        if (this.errorMap.size() == 0) {
            return;
        }
        int count = 0;
        int others = 0;
        List<Map.Entry<String, Integer>> errors = this.getSortedList();
        for (Map.Entry<String, Integer> e : errors) {
            if (++count < 32) {
                MetricProtos.EmrMetricErrorItem.Builder b = MetricProtos.EmrMetricErrorItem.newBuilder();
                b.setError(e.getKey());
                b.setCount(e.getValue());
                vb.addErrors(b);
                continue;
            }
            if (count < 32) continue;
            others += e.getValue().intValue();
        }
        if (others > 0) {
            MetricProtos.EmrMetricErrorItem.Builder b = MetricProtos.EmrMetricErrorItem.newBuilder();
            b.setError("others");
            b.setCount(others);
            vb.addErrors(b);
        }
    }

    public List<Map.Entry<String, Integer>> getTop(int n) {
        List<Map.Entry<String, Integer>> errors;
        if (n < 1) {
            n = 10;
        }
        if ((errors = this.getSortedList()).size() <= n) {
            return errors;
        }
        while (errors.size() > n) {
            errors.remove(n);
        }
        return errors;
    }

    private List<Map.Entry<String, Integer>> getSortedList() {
        ArrayList<Map.Entry<String, Integer>> errors = new ArrayList<Map.Entry<String, Integer>>();
        errors.addAll(this.errorMap.entrySet());
        Collections.sort(errors, COMPARATOR);
        return errors;
    }
}

