/*
 * Decompiled with CFR 0.152.
 */
package amazon.emr.metrics;

import amazon.emr.MetricProtos;
import amazon.emr.metrics.TimeInterval;
import amazon.emr.metrics.ValueCountMap;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUtil {
    static Logger logger = LoggerFactory.getLogger(ClientUtil.class);
    static String instanceId = null;

    public static boolean fileExists(String filename) throws IOException {
        File file = new File(filename);
        return file.exists();
    }

    public static String getHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException ex) {
            return "unknown";
        }
    }

    public static String getPidStr() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }

    public static int getPid() {
        try {
            String idstr = ClientUtil.getPidStr();
            return Integer.parseInt(idstr);
        }
        catch (Exception ex) {
            logger.info("Failed to getPid");
            return 0;
        }
    }

    public static String getSysLogS3Bucket(String domain, String realm) {
        if (domain.equals("prod")) {
            return realm.endsWith("us-east-1") ? "aws157-logs-prod" : "aws157-logs-prod-" + realm;
        }
        if (domain.equals("preprod")) {
            return realm.endsWith("us-east-1") ? "aws157-logs-preprod" : "aws157-logs-preprod-" + realm;
        }
        if (domain.equals("test")) {
            return realm.endsWith("us-east-1") ? "aws157-logs-test" : "aws157-logs-test-" + realm;
        }
        String localhost = ClientUtil.getHostName();
        int i = localhost.indexOf(46);
        if (i > 0) {
            localhost = localhost.substring(0, i);
        }
        return "aws157-logs-desktop-" + localhost;
    }

    public static String readFileAsString(String filename) {
        String content = null;
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(filename, new String[0]));
            content = new String(encoded, "UTF-8");
        }
        catch (IOException e) {
            logger.info("Failed to read {}", (Object)filename);
        }
        return content;
    }

    public static String getInstanceId() {
        if (instanceId != null) {
            return instanceId;
        }
        String hostname = ClientUtil.getHostName();
        String instance = ClientUtil.getFakeInstanceIdFromHost(hostname);
        if (!hostname.contains(".amazon.com")) {
            int timeout = hostname.contains(".ec2.internal") ? 30000 : 2000;
            String url = "http://169.254.169.254/latest/meta-data/instance-id";
            try {
                BasicHttpParams httpParams = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeout);
                DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)httpParams);
                HttpGet getRequest = new HttpGet("http://169.254.169.254/latest/meta-data/instance-id");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
                int status = response.getStatusLine().getStatusCode();
                if (status != 200) {
                    logger.info("error status code {} GET {}", (Object)status, (Object)"http://169.254.169.254/latest/meta-data/instance-id");
                } else {
                    instance = EntityUtils.toString((HttpEntity)response.getEntity()).replace(':', '_');
                }
                httpClient.getConnectionManager().shutdown();
            }
            catch (Exception e) {
                logger.info("GET {} exception {}", (Object)"http://169.254.169.254/latest/meta-data/instance-id", (Object)e);
            }
        }
        instanceId = instance;
        return instance;
    }

    private static String getFakeInstanceIdFromHost(String host) {
        host.replace(':', '_');
        int dotIndex = host.indexOf(46);
        return dotIndex > 0 ? host.substring(0, dotIndex) : host;
    }

    public static String getProcessMainClassName(boolean shortname) {
        try {
            Map<Thread, StackTraceElement[]> stackTraceMap = Thread.getAllStackTraces();
            if (stackTraceMap.size() > 100) {
                logger.info("Skip searching {} stacks for main class name, use pid", (Object)stackTraceMap.size());
                return ClientUtil.getPidStr();
            }
            for (Map.Entry<Thread, StackTraceElement[]> e : stackTraceMap.entrySet()) {
                StackTraceElement frame;
                Thread t = e.getKey();
                StackTraceElement[] frames = e.getValue();
                if (!"main".equals(t.getName()) || !"main".equals((frame = frames[frames.length - 1]).getMethodName())) continue;
                return ClientUtil.getClassNameHelper(frame.getClassName(), shortname);
            }
            for (Map.Entry<Thread, StackTraceElement[]> e : stackTraceMap.entrySet()) {
                StackTraceElement frame;
                StackTraceElement[] frames = e.getValue();
                if (frames == null || frames.length <= 0 || !"main".equals((frame = frames[frames.length - 1]).getMethodName())) continue;
                return ClientUtil.getClassNameHelper(frame.getClassName(), shortname);
            }
            return ClientUtil.getPidStr();
        }
        catch (Exception ex) {
            logger.info("getProcessMainClassName error {}", (Object)ex.getMessage());
            return null;
        }
    }

    private static String getClassNameHelper(String name, boolean shortname) {
        String[] parts = name.split("\\.");
        int len = parts.length;
        if (!shortname || len <= 1) {
            return name;
        }
        return parts[len - 1].equals("Main") || parts[len - 1].equals("main") ? parts[len - 2] : parts[len - 1];
    }

    public static MetricProtos.EmrMetricRecord aggregateRawValues(MetricProtos.EmrMetricRecord r, int maxDensity) {
        int count = r.getValuesCount();
        if (count <= maxDensity) {
            return r;
        }
        int durationSec = 1 + (int)(ClientUtil.getDuration(r) / 1000L);
        if (count < durationSec * maxDensity) {
            return r;
        }
        MetricProtos.EmrMetricRecord.Builder rb = MetricProtos.EmrMetricRecord.newBuilder();
        rb.setKey(r.getKey());
        rb.addAllValuesEx(r.getValuesExList());
        List<MetricProtos.EmrMetricAggregatedValue> aggValues = ClientUtil.aggregateRawValues(r.getValuesList());
        if (aggValues.size() > 0) {
            rb.addAllValuesEx(aggValues);
        }
        return rb.build();
    }

    public static List<MetricProtos.EmrMetricAggregatedValue> aggregateRawValues(List<MetricProtos.EmrMetricRawValue> values) {
        ArrayList<MetricProtos.EmrMetricAggregatedValue> output = new ArrayList<MetricProtos.EmrMetricAggregatedValue>();
        if (values == null || values.size() == 0) {
            return output;
        }
        TimeInterval interval = new TimeInterval(values.get(0).getTime(), 1000L);
        ValueCountMap countMap = new ValueCountMap();
        for (MetricProtos.EmrMetricRawValue v : values) {
            if (v.getTime() >= interval.stop) {
                output.add(countMap.aggregate(interval));
                interval = new TimeInterval(v.getTime(), 1000L);
                countMap = new ValueCountMap();
            }
            countMap.add(v);
        }
        output.add(countMap.aggregate(interval));
        return output;
    }

    public static MetricProtos.EmrMetricAggregatedValue aggregateRecords(Vector<MetricProtos.EmrMetricRecord> records) {
        if (records.size() == 0) {
            return null;
        }
        ValueCountMap countMap = new ValueCountMap();
        countMap.addRecords(records);
        return countMap.aggregate();
    }

    public static MetricProtos.EmrMetricAggregatedValue aggregateRecords(ArrayList<MetricProtos.EmrMetricRecord> records) {
        if (records.size() == 0) {
            return null;
        }
        ValueCountMap countMap = new ValueCountMap();
        countMap.addRecords(records);
        return countMap.aggregate();
    }

    public static long getMinTimeStamp(MetricProtos.EmrMetricRecord r) {
        if (r.getValuesCount() > 0) {
            return r.getValues(0).getTime();
        }
        if (r.getValuesExCount() > 0) {
            return r.getValuesEx(0).getStart();
        }
        return 0L;
    }

    public static long getMaxTimeStampInclusive(MetricProtos.EmrMetricRecord r) {
        if (r.getValuesCount() > 0) {
            return r.getValues(r.getValuesCount() - 1).getTime();
        }
        if (r.getValuesExCount() > 0) {
            return r.getValuesEx(r.getValuesExCount() - 1).getStop() - 1L;
        }
        return 0L;
    }

    public static long getMaxTimeStamp(MetricProtos.EmrMetricRecord r) {
        if (r.getValuesCount() > 0) {
            return r.getValues(r.getValuesCount() - 1).getTime();
        }
        if (r.getValuesExCount() > 0) {
            return r.getValuesEx(r.getValuesExCount() - 1).getStop();
        }
        return 0L;
    }

    public static long getDuration(MetricProtos.EmrMetricRecord r) {
        return ClientUtil.getMaxTimeStamp(r) - ClientUtil.getMinTimeStamp(r);
    }
}

