/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.oidc;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.talend.esb.security.oidc.OidcClientUtils;

public class OIDCRESTOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private String username;
    private String password;
    private Map<String, String> oidcProperties;

    public OIDCRESTOutInterceptor(String username, String password) {
        super("post-protocol");
        this.username = username;
        this.password = password;
    }

    public OIDCRESTOutInterceptor(String username, String password, Map<String, String> oidcProperties) {
        super("post-protocol");
        this.username = username;
        this.password = password;
        this.oidcProperties = oidcProperties;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isRequestor(message)) {
            Map headers = (Map)message.get((Object)Message.PROTOCOL_HEADERS);
            try {
                headers.put("Authorization", Collections.singletonList(OidcClientUtils.oidcClientBearer(this.username, this.password, this.oidcProperties)));
            }
            catch (RuntimeException ex) {
                throw new Fault((Throwable)ex);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
            }
        }
    }
}

