/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.oidc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.json.JSONProvider;
import org.talend.esb.security.oidc.OidcClientUtils;
import org.talend.esb.security.oidc.OidcConfiguration;

@PreMatching
@Priority(value=1000)
public class OidcAccessTokenValidator
implements ContainerRequestFilter {
    private OidcConfiguration oidcConfiguration = OidcClientUtils.getOidcConfiguration();

    public OidcAccessTokenValidator() {
    }

    public OidcAccessTokenValidator(OidcConfiguration oidcConfiguration) {
        this.oidcConfiguration = oidcConfiguration;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String accessToken;
        boolean authFailed = true;
        String authzHeader = (String)requestContext.getHeaders().getFirst((Object)"Authorization");
        if (authzHeader != null && authzHeader.startsWith("Bearer ") && (accessToken = authzHeader.substring("Bearer ".length())) != null && !accessToken.isEmpty()) {
            String validationEndpoint = this.oidcConfiguration.getValidationEndpoint();
            if (validationEndpoint == null) {
                throw new RuntimeException("Location of Oidc validation endpoint is not set");
            }
            WebClient oidcWebClient = WebClient.create((String)validationEndpoint, Collections.singletonList(new JSONProvider())).type("application/x-www-form-urlencoded");
            Response response = oidcWebClient.post((Object)("token=" + URLEncoder.encode(accessToken, "UTF-8") + "&token_type_hint=access_token"));
            try {
                Map<String, String> map = OidcClientUtils.parseJson((InputStream)response.getEntity());
                String active = map.get("active");
                if (active != null && active.equalsIgnoreCase("true")) {
                    authFailed = false;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (authFailed) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
            builder.header("WWW-Authenticate", (Object)"Bearer");
            requestContext.abortWith(builder.build());
        }
    }
}

