/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.saml.SamlFormOutInterceptor;
import org.apache.cxf.rs.security.saml.SamlHeaderOutInterceptor;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSClient;

public class STSRESTOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(STSRESTOutInterceptor.class);
    private STSClient stsClient;
    protected SecurityToken securityToken;

    public STSRESTOutInterceptor() {
        super("write");
        this.addBefore(SamlFormOutInterceptor.class.getName());
        this.addBefore(SamlHeaderOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        Object o;
        if (!this.isRequestor(message)) {
            return;
        }
        if (this.securityToken != null && !this.securityToken.isExpired() && this.securityToken.getToken() != null) {
            message.put((Object)"rs-security.saml.token.element", (Object)this.securityToken.getToken());
            return;
        }
        if (this.stsClient == null) {
            return;
        }
        Object token = message.getContextualProperty("security.sts.token.act-as");
        if (token != null) {
            this.stsClient.setActAs(token);
        }
        if ((token = message.getContextualProperty("security.sts.token.on-behalf-of")) != null) {
            this.stsClient.setOnBehalfOf(token);
        }
        String appliesTo = (o = message.getContextualProperty("security.sts.applies-to")) == null ? null : o.toString();
        this.stsClient.setMessage(message);
        try {
            SecurityToken tok = null;
            tok = this.securityToken == null || !this.stsClient.isAllowRenewing() ? this.stsClient.requestSecurityToken(appliesTo) : this.renewToken(this.securityToken, message, appliesTo);
            this.securityToken = tok;
        }
        catch (RuntimeException ex) {
            this.securityToken = null;
            throw new Fault((Throwable)ex);
        }
        catch (Exception ex) {
            this.securityToken = null;
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            throw new Fault((Throwable)new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
        if (this.securityToken != null && this.securityToken.getToken() != null) {
            message.put((Object)"rs-security.saml.token.element", (Object)this.securityToken.getToken());
        }
    }

    private SecurityToken renewToken(SecurityToken tok, Message message, String appliesTo) throws Exception {
        boolean issueAfterFailedRenew = MessageUtils.getContextualBoolean((Message)message, (String)"security.issue.after.failed.renew", (boolean)true);
        try {
            return this.stsClient.renewSecurityToken(tok);
        }
        catch (RuntimeException ex) {
            LOG.log(Level.WARNING, "Error renewing a token", ex);
            if (issueAfterFailedRenew) {
                return this.stsClient.requestSecurityToken(appliesTo);
            }
            throw ex;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Error renewing a token", ex);
            if (issueAfterFailedRenew) {
                return this.stsClient.requestSecurityToken(appliesTo);
            }
            throw ex;
        }
    }

    public STSClient getStsClient() {
        return this.stsClient;
    }

    public void setStsClient(STSClient stsClient) {
        this.stsClient = stsClient;
    }
}

