/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.service.soap.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.interceptor.security.JAASLoginInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.neethi.Policy;
import org.apache.wss4j.dom.validate.JAASUsernameTokenValidator;
import org.talend.esb.sam.service.soap.security.EsbSecurityConstants;
import org.talend.esb.sam.service.soap.security.WSPasswordCallbackHandler;

public class SAMServiceSecurityProvider {
    private EndpointImpl serviceEndpoint;
    private String authenticationType;
    private String policyUsernameToken;
    private String policySaml;
    private String signatureProperties;
    private String signatureUsername;
    private String signaturePassword;
    private static final String ENDPOINT_SIGNATURE_PASSWORD = "security.signature.password";

    public EndpointImpl getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(EndpointImpl serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getPolicyUsernameToken() {
        return this.policyUsernameToken;
    }

    public void setPolicyUsernameToken(String policyUsernameToken) {
        this.policyUsernameToken = policyUsernameToken;
    }

    public String getPolicySaml() {
        return this.policySaml;
    }

    public void setPolicySaml(String policySaml) {
        this.policySaml = policySaml;
    }

    public String getSignatureProperties() {
        return this.signatureProperties;
    }

    public void setSignatureProperties(String signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
    }

    public String getSignaturePassword() {
        return this.signaturePassword;
    }

    public void setSignaturePassword(String signaturePassword) {
        this.signaturePassword = signaturePassword;
    }

    @PostConstruct
    public void init() {
        EsbSecurityConstants esbSecurity = EsbSecurityConstants.fromString(this.authenticationType);
        if (EsbSecurityConstants.NO == esbSecurity) {
            return;
        }
        Bus bus = this.serviceEndpoint.getBus();
        ArrayList<Policy> policies = new ArrayList<Policy>();
        WSPolicyFeature policyFeature = new WSPolicyFeature();
        policyFeature.setPolicies(policies);
        HashMap<String, Object> properties = this.serviceEndpoint.getProperties();
        if (null == properties) {
            properties = new HashMap<String, Object>();
        }
        if (EsbSecurityConstants.BASIC == esbSecurity) {
            JAASLoginInterceptor interceptor = new JAASLoginInterceptor();
            interceptor.setContextName("karaf");
            this.serviceEndpoint.getInInterceptors().add(interceptor);
        } else if (EsbSecurityConstants.USERNAMETOKEN == esbSecurity) {
            policies.add(this.loadPolicy(this.policyUsernameToken, bus));
            JAASUsernameTokenValidator jaasUTValidator = new JAASUsernameTokenValidator();
            jaasUTValidator.setContextName("karaf");
            properties.put("ws-security.ut.validator", jaasUTValidator);
            this.serviceEndpoint.setProperties(properties);
        } else if (EsbSecurityConstants.SAML == esbSecurity) {
            policies.add(this.loadPolicy(this.policySaml, bus));
            properties.put("security.signature.properties", this.getSignatureProperties());
            properties.put("security.signature.username", this.getSignatureUsername());
            properties.put(ENDPOINT_SIGNATURE_PASSWORD, this.getSignaturePassword());
            properties.put("security.callback-handler", new WSPasswordCallbackHandler(this.getSignatureUsername(), this.getSignaturePassword()));
            this.serviceEndpoint.setProperties(properties);
        }
        this.serviceEndpoint.getFeatures().add(policyFeature);
        ServerRegistry registry = (ServerRegistry)bus.getExtension(ServerRegistry.class);
        List servers = registry.getServers();
        for (Server server : servers) {
            if (server.getEndpoint().getService() != this.serviceEndpoint.getService()) continue;
            policyFeature.initialize(server, bus);
        }
    }

    private Policy loadPolicy(String location, Bus cxf) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(location);
            Policy policy = ((PolicyBuilder)cxf.getExtension(PolicyBuilder.class)).getPolicy((InputStream)is);
            return policy;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load policy", e);
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

