/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.service.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.cxf.helpers.IOUtils;
import org.talend.esb.sam._2011._03.common.CustomInfoType;
import org.talend.esb.sam._2011._03.common.EventEnumType;
import org.talend.esb.sam._2011._03.common.EventType;
import org.talend.esb.sam._2011._03.common.MessageInfoType;
import org.talend.esb.sam._2011._03.common.OriginatorType;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;

public final class EventTypeMapper {
    private EventTypeMapper() {
    }

    public static Event map(EventType eventType) {
        Event event = new Event();
        event.setEventType(EventTypeMapper.mapEventTypeEnum(eventType.getEventType()));
        Date date = eventType.getTimestamp() == null ? new Date() : eventType.getTimestamp().toGregorianCalendar().getTime();
        event.setTimestamp(date);
        event.setOriginator(EventTypeMapper.mapOriginatorType(eventType.getOriginator()));
        MessageInfo messageInfo = EventTypeMapper.mapMessageInfo(eventType.getMessageInfo());
        event.setMessageInfo(messageInfo);
        String content = EventTypeMapper.mapContent(eventType.getContent());
        event.setContent(content);
        event.getCustomInfo().clear();
        event.getCustomInfo().putAll(EventTypeMapper.mapCustomInfo(eventType.getCustomInfo()));
        return event;
    }

    private static Map<String, String> mapCustomInfo(CustomInfoType ciType) {
        HashMap<String, String> customInfo = new HashMap<String, String>();
        if (ciType != null) {
            for (CustomInfoType.Item item : ciType.getItem()) {
                customInfo.put(item.getKey(), item.getValue());
            }
        }
        return customInfo;
    }

    private static String mapContent(DataHandler dh) {
        if (dh == null) {
            return "";
        }
        try {
            InputStream is = dh.getInputStream();
            String content = IOUtils.toString((InputStream)is);
            is.close();
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static MessageInfo mapMessageInfo(MessageInfoType messageInfoType) {
        MessageInfo messageInfo = new MessageInfo();
        if (messageInfoType != null) {
            messageInfo.setFlowId(messageInfoType.getFlowId());
            messageInfo.setMessageId(messageInfoType.getMessageId());
            messageInfo.setOperationName(messageInfoType.getOperationName());
            messageInfo.setPortType(messageInfoType.getPorttype() == null ? "" : messageInfoType.getPorttype().toString());
            messageInfo.setTransportType(messageInfoType.getTransport());
        }
        return messageInfo;
    }

    private static Originator mapOriginatorType(OriginatorType originatorType) {
        Originator originator = new Originator();
        if (originatorType != null) {
            originator.setCustomId(originatorType.getCustomId());
            originator.setHostname(originatorType.getHostname());
            originator.setIp(originatorType.getIp());
            originator.setProcessId(originatorType.getProcessId());
            originator.setPrincipal(originatorType.getPrincipal());
        }
        return originator;
    }

    private static EventTypeEnum mapEventTypeEnum(EventEnumType eventType) {
        if (eventType != null) {
            return EventTypeEnum.valueOf((String)eventType.name());
        }
        return EventTypeEnum.UNKNOWN;
    }
}

