/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.soap.service;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.persistence.EventRepository;
import org.talend.esb.sam.common.service.MonitoringService;
import org.talend.esb.sam.common.spi.EventFilter;
import org.talend.esb.sam.common.spi.EventHandler;

public class MonitoringServiceImpl
implements MonitoringService {
    @Autowired(required=false)
    private List<EventFilter> eventFilters = new ArrayList<EventFilter>();
    @Autowired(required=false)
    private List<EventHandler> eventHandlers = new ArrayList<EventHandler>();
    private EventRepository persistenceHandler;

    public void setEventFilters(List<EventFilter> eventFilters) {
        this.eventFilters = eventFilters;
    }

    public void setEventHandlers(List<EventHandler> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    public void setPersistenceHandler(EventRepository persistenceHandler) {
        this.persistenceHandler = persistenceHandler;
    }

    public void putEvents(List<Event> events) {
        List<Event> filteredEvents = this.filterEvents(events);
        this.executeHandlers(filteredEvents);
        for (Event event : filteredEvents) {
            this.persistenceHandler.writeEvent(event);
        }
    }

    private boolean filter(Event event) {
        for (EventFilter filter : this.eventFilters) {
            if (!filter.filter(event)) continue;
            return true;
        }
        return false;
    }

    private List<Event> filterEvents(List<Event> events) {
        ArrayList<Event> filteredEvents = new ArrayList<Event>();
        for (Event event : events) {
            if (this.filter(event)) continue;
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    private void executeHandlers(List<Event> filteredEvents) {
        for (EventHandler current : this.eventHandlers) {
            for (Event event : filteredEvents) {
                current.handleEvent(event);
            }
        }
    }
}

