/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.soap.service;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.cxf.helpers.IOUtils;
import org.springframework.jdbc.core.RowMapper;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;

public class EventRowMapper
implements RowMapper<Event> {
    public Event mapRow(ResultSet rs, int rowNum) throws SQLException {
        Event event = new Event();
        event.setPersistedId(Long.valueOf(rs.getLong("ID")));
        event.setTimestamp((Date)rs.getTimestamp("EI_TIMESTAMP"));
        event.setEventType(EventTypeEnum.valueOf((String)rs.getString("EI_EVENT_TYPE")));
        Originator originator = new Originator();
        originator.setProcessId(rs.getString("ORIG_PROCESS_ID"));
        originator.setIp(rs.getString("ORIG_IP"));
        originator.setHostname(rs.getString("ORIG_HOSTNAME"));
        originator.setCustomId(rs.getString("ORIG_CUSTOM_ID"));
        originator.setPrincipal(rs.getString("ORIG_PRINCIPAL"));
        event.setOriginator(originator);
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageId(rs.getString("MI_MESSAGE_ID"));
        messageInfo.setFlowId(rs.getString("MI_FLOW_ID"));
        messageInfo.setPortType(rs.getString("MI_PORT_TYPE"));
        messageInfo.setOperationName(rs.getString("MI_OPERATION_NAME"));
        messageInfo.setTransportType(rs.getString("MI_TRANSPORT_TYPE"));
        event.setMessageInfo(messageInfo);
        event.setContentCut(rs.getBoolean("CONTENT_CUT"));
        try {
            event.setContent(IOUtils.toString((InputStream)rs.getClob("MESSAGE_CONTENT").getAsciiStream()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading content", e);
        }
        return event;
    }
}

