/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.soap.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.esb.sam._2011._03.common.EventType;
import org.talend.esb.sam._2011._03.common.FaultType;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.MonitoringException;
import org.talend.esb.sam.common.service.MonitoringService;
import org.talend.esb.sam.monitoringservice.v1.PutEventsFault;
import org.talend.esb.sam.soap.service.EventTypeMapper;

public class MonitoringWebService
implements org.talend.esb.sam.monitoringservice.v1.MonitoringService {
    private static final Logger LOG = Logger.getLogger(MonitoringWebService.class.getName());
    private MonitoringService monitoringService;

    public void setMonitoringService(MonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }

    public String putEvents(List<EventType> eventTypes) throws PutEventsFault {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Received event(" + eventTypes.size() + ") from Agent.");
        }
        ArrayList<Event> events = new ArrayList<Event>(eventTypes.size());
        try {
            for (EventType eventType : eventTypes) {
                events.add(EventTypeMapper.map(eventType));
            }
        }
        catch (RuntimeException e) {
            MonitoringWebService.throwFault("004", "Could not map web service data to event." + e.getMessage(), e);
        }
        try {
            this.monitoringService.putEvents(events);
        }
        catch (MonitoringException e) {
            e.logException(Level.SEVERE);
            MonitoringWebService.throwFault(e.getCode(), e.getMessage(), e);
        }
        catch (Throwable t) {
            MonitoringWebService.throwFault("000", "Unknown error " + t.getMessage(), t);
        }
        return "success";
    }

    private static void throwFault(String code, String message, Throwable t) throws PutEventsFault {
        if (LOG.isLoggable(Level.SEVERE)) {
            LOG.log(Level.SEVERE, "Throw Fault " + code + " " + message, t);
        }
        FaultType faultType = new FaultType();
        faultType.setFaultCode(code);
        faultType.setFaultMessage(message);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        faultType.setStackTrace(stringWriter.toString());
        throw new PutEventsFault(message, faultType, t);
    }
}

