/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.talend.esb.sam.common.event.EventTypeEnum;
import org.talend.esb.sam.server.ui.CriteriaAdapter;
import org.talend.esb.sam.service.AggregatedFlow;
import org.talend.esb.sam.service.AggregatedFlowCollection;
import org.talend.esb.sam.service.AggregatedFlowEvent;
import org.talend.esb.sam.service.CustomInfo;
import org.talend.esb.sam.service.Flow;
import org.talend.esb.sam.service.FlowCollection;
import org.talend.esb.sam.service.FlowDetails;
import org.talend.esb.sam.service.FlowEvent;
import org.talend.esb.sam.service.SAMProvider;
import org.talend.esb.sam.service.SAMRestService;
import org.talend.esb.sam.service.exception.IllegalParameterException;
import org.talend.esb.sam.service.exception.ResourceNotFoundException;

public class SAMRestServiceImpl
implements SAMRestService {
    SAMProvider provider;
    @Context
    protected UriInfo uriInfo;
    private final String ALIVE_CHECK_TEXT = "Talend Service Activity Monitoring Server :: REST API - ";

    public void setProvider(SAMProvider provider) {
        this.provider = provider;
    }

    @Override
    public Response checkAlive() {
        String startUrl = this.uriInfo.getBaseUriBuilder().path("list").build(new Object[0]).toString();
        return Response.ok((Object)("Talend Service Activity Monitoring Server :: REST API - " + startUrl)).type("text/plain").build();
    }

    @Override
    public Response getEvent(String id) {
        Integer eventId;
        try {
            eventId = Integer.parseInt(id);
        }
        catch (NumberFormatException ex) {
            throw new IllegalParameterException("Error during converting " + id + " parameter to Integer", (Throwable)ex);
        }
        FlowEvent event = this.provider.getEventDetails(eventId);
        if (null == event) {
            throw new ResourceNotFoundException("There no event with " + id + " ID can be found");
        }
        return Response.ok((Object)event).build();
    }

    @Override
    public Response getFlow(String flowID) {
        List<FlowEvent> flowEvents = this.provider.getFlowDetails(flowID);
        if (0 == flowEvents.size()) {
            throw new ResourceNotFoundException("There no flow with " + flowID + " ID can be found");
        }
        return Response.ok((Object)this.aggregateFlowDetails(flowEvents)).build();
    }

    @Override
    public Response getFlows(Integer offset, Integer limit) {
        HashMap params = new HashMap();
        MultivaluedMap queryParams = this.uriInfo.getQueryParameters();
        for (Map.Entry entry : queryParams.entrySet()) {
            params.put(entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
        }
        CriteriaAdapter adapter = new CriteriaAdapter((long)offset.intValue(), (long)limit.intValue(), params);
        FlowCollection flowCollection = this.provider.getFlows(adapter);
        return Response.ok((Object)this.aggregateRawData(flowCollection)).build();
    }

    public FlowDetails aggregateFlowDetails(List<FlowEvent> flowEvents) {
        HashMap customInfo = new HashMap();
        HashSet<Long> allEvents = new HashSet<Long>();
        for (FlowEvent flowEvent : flowEvents) {
            long flowEventId = flowEvent.getId();
            allEvents.add(flowEventId);
            String custKey = flowEvent.getCustomKey();
            String custValue = flowEvent.getCustomValue();
            if (null == custKey) continue;
            if (!customInfo.containsKey(flowEventId)) {
                customInfo.put(flowEventId, new ArrayList());
            }
            CustomInfo custom = new CustomInfo();
            custom.setKey(custKey);
            custom.setValue(custValue);
            ((List)customInfo.get(flowEventId)).add(custom);
        }
        ArrayList<AggregatedFlowEvent> aggregatedFlowEventList = new ArrayList<AggregatedFlowEvent>();
        for (FlowEvent flowEvent : flowEvents) {
            long flowEventId = flowEvent.getId();
            if (!allEvents.contains(flowEventId)) continue;
            allEvents.remove(flowEventId);
            AggregatedFlowEvent aggregatedFlowEvent = new AggregatedFlowEvent();
            aggregatedFlowEvent.setContentCut(flowEvent.isContentCut());
            aggregatedFlowEvent.setCustomId(flowEvent.getCustomId());
            aggregatedFlowEvent.setDetails(this.uriInfo.getBaseUriBuilder().path("event").path(String.valueOf(flowEventId)).build(new Object[0]));
            aggregatedFlowEvent.setType(flowEvent.getType());
            aggregatedFlowEvent.setFlowID(flowEvent.getFlowID());
            aggregatedFlowEvent.setHost(flowEvent.getHost());
            aggregatedFlowEvent.setId(flowEventId);
            aggregatedFlowEvent.setIp(flowEvent.getIp());
            aggregatedFlowEvent.setMessageID(flowEvent.getMessageID());
            aggregatedFlowEvent.setOperation(flowEvent.getOperation());
            aggregatedFlowEvent.setPort(flowEvent.getPort());
            aggregatedFlowEvent.setPrincipal(flowEvent.getPrincipal());
            aggregatedFlowEvent.setProcess(flowEvent.getProcess());
            aggregatedFlowEvent.setTimestamp(flowEvent.getTimestamp());
            aggregatedFlowEvent.setTransport(flowEvent.getTransport());
            if (customInfo.containsKey(flowEventId)) {
                aggregatedFlowEvent.setCustomInfo((List)customInfo.get(flowEventId));
            }
            aggregatedFlowEventList.add(aggregatedFlowEvent);
        }
        FlowDetails flowDetails = new FlowDetails();
        flowDetails.setEvents(aggregatedFlowEventList);
        return flowDetails;
    }

    public AggregatedFlowCollection aggregateRawData(FlowCollection collection) {
        HashMap<String, Long> flowLastTimestamp = new HashMap<String, Long>();
        HashMap<String, String> flowProviderIP = new HashMap<String, String>();
        HashMap<String, String> flowProviderHost = new HashMap<String, String>();
        HashMap<String, String> flowConsumerIP = new HashMap<String, String>();
        HashMap<String, String> flowConsumerHost = new HashMap<String, String>();
        HashMap flowTypes = new HashMap();
        HashMap<String, String> flowConsumerPort = new HashMap<String, String>();
        HashMap<String, String> flowConsumerOperation = new HashMap<String, String>();
        HashMap<String, String> flowProviderPort = new HashMap<String, String>();
        HashMap<String, String> flowProviderOperation = new HashMap<String, String>();
        for (Flow obj : collection.getFlows()) {
            if (null == obj.getflowID() || obj.getflowID().isEmpty()) continue;
            String flowID = obj.getflowID();
            flowLastTimestamp.put(flowID, obj.getTimestamp());
            if (!flowTypes.containsKey(flowID)) {
                flowTypes.put(flowID, new HashSet());
            }
            EventTypeEnum typeEnum = obj.getEventType();
            ((Set)flowTypes.get(flowID)).add(typeEnum.toString());
            boolean isConsumer = typeEnum == EventTypeEnum.REQ_OUT || typeEnum == EventTypeEnum.RESP_IN || typeEnum == EventTypeEnum.FAULT_IN;
            boolean isProvider = typeEnum == EventTypeEnum.REQ_IN || typeEnum == EventTypeEnum.RESP_OUT || typeEnum == EventTypeEnum.FAULT_OUT;
            String host = obj.getHost();
            String ip = obj.getIp();
            String port = obj.getPort();
            String operation = obj.getOperation();
            if (isConsumer) {
                flowConsumerIP.put(flowID, ip);
                flowConsumerHost.put(flowID, host);
                flowConsumerPort.put(flowID, port);
                flowConsumerOperation.put(flowID, operation);
            }
            if (!isProvider) continue;
            flowProviderIP.put(flowID, ip);
            flowProviderHost.put(flowID, host);
            flowProviderPort.put(flowID, port);
            flowProviderOperation.put(flowID, operation);
        }
        ArrayList<AggregatedFlow> result = new ArrayList<AggregatedFlow>();
        for (Flow obj : collection.getFlows()) {
            Long startTime;
            String flowID = obj.getflowID();
            if (null == flowID || flowID.isEmpty() || null == (startTime = (Long)flowLastTimestamp.remove(flowID))) continue;
            AggregatedFlow aggregatedFlow = new AggregatedFlow();
            aggregatedFlow.setFlowID(flowID);
            if (flowProviderPort.containsKey(flowID)) {
                aggregatedFlow.setPort((String)flowProviderPort.get(flowID));
                aggregatedFlow.setOperation((String)flowProviderOperation.get(flowID));
            } else {
                aggregatedFlow.setPort((String)flowConsumerPort.get(flowID));
                aggregatedFlow.setOperation((String)flowConsumerOperation.get(flowID));
            }
            aggregatedFlow.setTransport(obj.getTransport());
            aggregatedFlow.setTypes((Set)flowTypes.get(flowID));
            long timestamp = obj.getTimestamp();
            aggregatedFlow.setTimestamp(timestamp);
            aggregatedFlow.setElapsed(timestamp - startTime);
            aggregatedFlow.setDetails(this.uriInfo.getBaseUriBuilder().path("flow").path(flowID).build(new Object[0]));
            if (flowConsumerHost.containsKey(flowID)) {
                aggregatedFlow.setConsumerHost((String)flowConsumerHost.get(flowID));
                aggregatedFlow.setConsumerIP((String)flowConsumerIP.get(flowID));
            }
            if (flowProviderHost.containsKey(flowID)) {
                aggregatedFlow.setProviderHost((String)flowProviderHost.get(flowID));
                aggregatedFlow.setProviderIP((String)flowProviderIP.get(flowID));
            }
            result.add(aggregatedFlow);
        }
        AggregatedFlowCollection fc = new AggregatedFlowCollection();
        fc.setAggregated(result);
        fc.setCount(collection.getCount());
        return fc;
    }
}

