/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.talend.esb.sam.server.persistence.dialects.DatabaseDialect;
import org.talend.esb.sam.server.persistence.dialects.QueryFilter;
import org.talend.esb.sam.server.ui.CriteriaAdapter;
import org.talend.esb.sam.service.EventMapper;
import org.talend.esb.sam.service.Flow;
import org.talend.esb.sam.service.FlowCollection;
import org.talend.esb.sam.service.FlowEvent;
import org.talend.esb.sam.service.FlowEventMapper;
import org.talend.esb.sam.service.FlowMapper;
import org.talend.esb.sam.service.SAMProvider;

public class SAMProviderImpl
extends SimpleJdbcDaoSupport
implements SAMProvider {
    private static final String SELECT_FLOW_QUERY = "select EVENTS.ID, EI_TIMESTAMP, EI_EVENT_TYPE, ORIG_CUSTOM_ID, ORIG_PROCESS_ID, ORIG_HOSTNAME, ORIG_IP, ORIG_PRINCIPAL, MI_PORT_TYPE, MI_OPERATION_NAME, MI_MESSAGE_ID, MI_FLOW_ID, MI_TRANSPORT_TYPE, CONTENT_CUT, CUST_KEY, CUST_VALUE from EVENTS left join EVENTS_CUSTOMINFO on EVENTS_CUSTOMINFO.EVENT_ID = EVENTS.ID where MI_FLOW_ID = :flowID";
    private static final String SELECT_EVENT_QUERY = "select ID, EI_TIMESTAMP, EI_EVENT_TYPE, ORIG_CUSTOM_ID, ORIG_PROCESS_ID, ORIG_HOSTNAME, ORIG_IP, ORIG_PRINCIPAL, MI_PORT_TYPE, MI_OPERATION_NAME, MI_MESSAGE_ID, MI_FLOW_ID, MI_TRANSPORT_TYPE, CONTENT_CUT, MESSAGE_CONTENT from EVENTS where ID = :eventID";
    private DatabaseDialect dialect;
    private final RowMapper<FlowEvent> eventMapper = new EventMapper();
    private final RowMapper<Flow> flowMapper = new FlowMapper();
    private final RowMapper<FlowEvent> flowEventMapper = new FlowEventMapper();

    public DatabaseDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public FlowEvent getEventDetails(Integer eventID) {
        List list = this.getSimpleJdbcTemplate().query(SELECT_EVENT_QUERY, this.eventMapper, Collections.singletonMap("eventID", eventID));
        if (list.isEmpty()) {
            return null;
        }
        return (FlowEvent)list.get(0);
    }

    @Override
    public List<FlowEvent> getFlowDetails(String flowID) {
        return this.getSimpleJdbcTemplate().query(SELECT_FLOW_QUERY, this.flowEventMapper, Collections.singletonMap("flowID", flowID));
    }

    @Override
    public FlowCollection getFlows(CriteriaAdapter criteria) {
        FlowCollection flowCollection = new FlowCollection();
        String whereClause = criteria.getWhereClause();
        String countQuery = this.dialect.getCountQuery().replaceAll("%%FILTER%%", whereClause != null && whereClause.length() > 0 ? " AND " + whereClause : "");
        int rowCount = this.getSimpleJdbcTemplate().queryForInt(countQuery, (SqlParameterSource)criteria);
        int offset = Integer.parseInt(criteria.getValue("offset").toString());
        int limit = Integer.parseInt(criteria.getValue("limit").toString());
        List flows = null;
        if (offset < rowCount) {
            String dataQuery = this.dialect.getDataQuery((QueryFilter)criteria);
            if (rowCount - offset < limit) {
                limit = rowCount - offset;
            }
            String soffset = String.valueOf(offset);
            String slimit = String.valueOf(limit);
            dataQuery = dataQuery.replaceAll("%%LIMIT%%", slimit).replaceAll("%%OFFSET%%", soffset);
            flows = this.getSimpleJdbcTemplate().query(dataQuery, this.flowMapper, (SqlParameterSource)criteria);
        }
        if (flows == null) {
            flows = new ArrayList();
        }
        flowCollection.setFlows(flows);
        flowCollection.setCount(rowCount);
        return flowCollection;
    }
}

