/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.persistence.dialects;

import javax.sql.DataSource;
import org.springframework.jdbc.support.incrementer.DB2SequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DerbyMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.H2SequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.MySQLMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.OracleSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.PostgreSQLSequenceMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.SqlServerMaxValueIncrementer;
import org.talend.esb.sam.server.persistence.dialects.DB2Dialect;
import org.talend.esb.sam.server.persistence.dialects.DatabaseDialect;
import org.talend.esb.sam.server.persistence.dialects.DerbyDialect;
import org.talend.esb.sam.server.persistence.dialects.H2Dialect;
import org.talend.esb.sam.server.persistence.dialects.MySQLDialect;
import org.talend.esb.sam.server.persistence.dialects.OracleDialect;
import org.talend.esb.sam.server.persistence.dialects.PostgreSQLDialect;
import org.talend.esb.sam.server.persistence.dialects.SqlServerDialect;

public class DialectFactory {
    private DerbyMaxValueIncrementer derbyIncrementer = new DerbyMaxValueIncrementer();
    private DB2SequenceMaxValueIncrementer db2Incrementer = new DB2SequenceMaxValueIncrementer();
    private MySQLMaxValueIncrementer mysqlIncrementer = new MySQLMaxValueIncrementer();
    private H2SequenceMaxValueIncrementer h2Incrementer = new H2SequenceMaxValueIncrementer();
    private OracleSequenceMaxValueIncrementer oracleIncrementer = new OracleSequenceMaxValueIncrementer();
    private SqlServerMaxValueIncrementer sqlServerIncrementer = new SqlServerMaxValueIncrementer();
    private PostgreSQLSequenceMaxValueIncrementer postgreSQLIncrementer = new PostgreSQLSequenceMaxValueIncrementer();
    private DatabaseDialect derbyDialect = new DerbyDialect();
    private DatabaseDialect db2Dialect = new DB2Dialect();
    private DatabaseDialect mysqlDialect = new MySQLDialect();
    private DatabaseDialect h2Dialect = new H2Dialect();
    private DatabaseDialect oracleDialect = new OracleDialect();
    private DatabaseDialect sqlServerDialect = new SqlServerDialect();
    private DatabaseDialect postgreSQLDialect = new PostgreSQLDialect();

    public DialectFactory(DataSource dataSource) {
        this.derbyIncrementer.setDataSource(dataSource);
        this.derbyIncrementer.setIncrementerName("TAB_SEQUENCE");
        this.derbyIncrementer.setColumnName("ID_VALUE");
        this.derbyDialect.setIncrementer((DataFieldMaxValueIncrementer)this.derbyIncrementer);
        this.db2Incrementer.setDataSource(dataSource);
        this.db2Incrementer.setIncrementerName("EVENT_ID");
        this.db2Dialect.setIncrementer((DataFieldMaxValueIncrementer)this.db2Incrementer);
        this.mysqlIncrementer.setDataSource(dataSource);
        this.mysqlIncrementer.setIncrementerName("SEQUENCE");
        this.mysqlIncrementer.setColumnName("SEQ_COUNT");
        this.mysqlDialect.setIncrementer((DataFieldMaxValueIncrementer)this.mysqlIncrementer);
        this.h2Incrementer.setDataSource(dataSource);
        this.h2Incrementer.setIncrementerName("ID_SEQUENCE");
        this.h2Dialect.setIncrementer((DataFieldMaxValueIncrementer)this.h2Incrementer);
        this.oracleIncrementer.setDataSource(dataSource);
        this.oracleIncrementer.setIncrementerName("EVENT_ID");
        this.oracleDialect.setIncrementer((DataFieldMaxValueIncrementer)this.oracleIncrementer);
        this.sqlServerIncrementer.setDataSource(dataSource);
        this.sqlServerIncrementer.setIncrementerName("SEQUENCE");
        this.sqlServerIncrementer.setColumnName("SEQ_COUNT");
        this.sqlServerDialect.setIncrementer((DataFieldMaxValueIncrementer)this.sqlServerIncrementer);
        this.postgreSQLIncrementer.setDataSource(dataSource);
        this.postgreSQLIncrementer.setIncrementerName("EVENT_ID");
        this.postgreSQLDialect.setIncrementer((DataFieldMaxValueIncrementer)this.postgreSQLIncrementer);
    }

    public DatabaseDialect getDialect(String dialectName) {
        if ("derbyDialect".equals(dialectName)) {
            return this.derbyDialect;
        }
        if ("DB2Dialect".equals(dialectName)) {
            return this.db2Dialect;
        }
        if ("mysqlDialect".equals(dialectName)) {
            return this.mysqlDialect;
        }
        if ("h2Dialect".equals(dialectName)) {
            return this.h2Dialect;
        }
        if ("oracleDialect".equals(dialectName)) {
            return this.oracleDialect;
        }
        if ("sqlServerDialect".equals(dialectName)) {
            return this.sqlServerDialect;
        }
        if ("postgresqlDialect".equals(dialectName)) {
            return this.postgreSQLDialect;
        }
        return null;
    }
}

