/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.persistence.criterias;

import java.sql.Timestamp;
import org.talend.esb.sam.server.persistence.criterias.Criteria;

public class DateCriteria
extends Criteria {
    private static final long MILLS_IN_DAY = 86399999L;
    private Timestamp value;

    public DateCriteria(String name, String colunmName) {
        super(name, colunmName);
    }

    @Override
    public Criteria[] parseValue(String attribute) {
        long attributeValue = Long.parseLong(attribute);
        if (this.name.endsWith("_on")) {
            DateCriteria after = new DateCriteria(this.name + "_after", this.columnName);
            after.value = new Timestamp(attributeValue - 43199999L);
            DateCriteria before = new DateCriteria(this.name + "_before", this.columnName);
            before.value = new Timestamp(attributeValue + 43199999L);
            return new Criteria[]{after, before};
        }
        DateCriteria result = new DateCriteria(this.name, this.columnName);
        result.value = new Timestamp(attributeValue);
        return new Criteria[]{result};
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public StringBuilder getFilterClause() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.columnName);
        if (this.name.lastIndexOf(95) > 0) {
            String suffix = this.name.substring(this.name.lastIndexOf(95) + 1);
            if ("before".equals(suffix)) {
                builder.append(" < ");
            } else if ("after".equals(suffix)) {
                builder.append(" > ");
            } else {
                builder.append(" = ");
            }
        } else {
            builder.append(" = ");
        }
        builder.append(':').append(this.name);
        return builder;
    }
}

