/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class JsonRowMapper
implements RowMapper<JsonObject> {
    private static final Map<String, String> NAME_MAPPING = new HashMap<String, String>(){
        {
            this.put("ID", "id");
            this.put("MI_FLOW_ID", "flowID");
            this.put("EI_TIMESTAMP", "timestamp");
            this.put("EI_EVENT_TYPE", "type");
            this.put("MI_PORT_TYPE", "port");
            this.put("MI_OPERATION_NAME", "operation");
            this.put("MI_TRANSPORT_TYPE", "transport");
            this.put("ORIG_HOSTNAME", "host");
            this.put("ORIG_IP", "ip");
            this.put("ORIG_CUSTOM_ID", "customID");
            this.put("ORIG_PROCESS_ID", "process");
            this.put("ORIG_PRINCIPAL", "principal");
            this.put("MI_MESSAGE_ID", "messageID");
            this.put("CONTENT_CUT", "contentCut");
            this.put("MESSAGE_CONTENT", "content");
            this.put("CUST_KEY", "custKey");
            this.put("CUST_VALUE", "custValue");
        }
    };
    private final RowMapper<Map<String, Object>> nestedMapper = new ColumnMapRowMapper();
    private final Gson gson;

    public JsonRowMapper() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Timestamp.class, (Object)new JsonSerializer<Timestamp>(){

            public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive((Number)src.getTime());
            }
        });
        this.gson = builder.create();
    }

    public JsonObject mapRow(ResultSet rs, int rowNum) throws SQLException {
        Map map = (Map)this.nestedMapper.mapRow(rs, rowNum);
        JsonObject row = new JsonObject();
        for (String key : map.keySet()) {
            String jsonName = NAME_MAPPING.get(key);
            if (jsonName == null) {
                jsonName = key;
            }
            row.add(jsonName, this.gson.toJsonTree(map.get(key)));
        }
        return row;
    }
}

