/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.talend.esb.sam.common.event.EventTypeEnum;

public class UIProviderUtils {
    private JsonParser parser = new JsonParser();
    private Gson gson = new Gson();

    public JsonArray aggregateFlowDetails(List<JsonObject> objects, String baseURL) {
        HashMap customInfo = new HashMap();
        HashSet<Long> allEvents = new HashSet<Long>();
        for (JsonObject obj : objects) {
            String custValue;
            long eventID = obj.get("id").getAsLong();
            allEvents.add(eventID);
            String custKey = obj.get("custKey").isJsonNull() ? null : obj.get("custKey").getAsString();
            String string = custValue = obj.get("custValue").isJsonNull() ? null : obj.get("custValue").getAsString();
            if (custKey == null) continue;
            if (!customInfo.containsKey(eventID)) {
                customInfo.put(eventID, new HashMap());
            }
            ((Map)customInfo.get(eventID)).put(custKey, custValue);
        }
        JsonArray result = new JsonArray();
        for (JsonObject obj : objects) {
            long eventID = obj.get("id").getAsLong();
            if (!allEvents.contains(eventID)) continue;
            allEvents.remove(eventID);
            JsonObject newObj = this.copy(obj);
            if (customInfo.containsKey(eventID)) {
                newObj.add("customInfo", this.gson.toJsonTree(customInfo.get(eventID)));
            }
            newObj.remove("custKey");
            newObj.remove("custValue");
            newObj.add("details", (JsonElement)new JsonPrimitive(baseURL + "event/" + newObj.get("id")));
            result.add((JsonElement)newObj);
        }
        return result;
    }

    public JsonArray aggregateRawData(List<JsonObject> objects, String baseURL) {
        HashMap<String, Long> flowLastTimestamp = new HashMap<String, Long>();
        HashMap<String, String> flowProviderIP = new HashMap<String, String>();
        HashMap<String, String> flowProviderHost = new HashMap<String, String>();
        HashMap<String, String> flowConsumerIP = new HashMap<String, String>();
        HashMap<String, String> flowConsumerHost = new HashMap<String, String>();
        HashMap flowTypes = new HashMap();
        for (JsonObject obj : objects) {
            if (null == obj.get("flowID") || obj.get("flowID").isJsonNull()) continue;
            String flowID = obj.get("flowID").getAsString();
            long timestamp = obj.get("timestamp").getAsLong();
            flowLastTimestamp.put(flowID, timestamp);
            if (!flowTypes.containsKey(flowID)) {
                flowTypes.put(flowID, new HashSet());
            }
            String eventType = obj.get("type").getAsString();
            ((Set)flowTypes.get(flowID)).add(eventType);
            EventTypeEnum typeEnum = EventTypeEnum.valueOf((String)eventType);
            boolean isConsumer = typeEnum == EventTypeEnum.REQ_OUT || typeEnum == EventTypeEnum.RESP_IN;
            boolean isProvider = typeEnum == EventTypeEnum.REQ_IN || typeEnum == EventTypeEnum.RESP_OUT;
            String host = obj.get("host").getAsString();
            String ip = obj.get("ip").getAsString();
            if (isConsumer) {
                flowConsumerIP.put(flowID, ip);
                flowConsumerHost.put(flowID, host);
            }
            if (!isProvider) continue;
            flowProviderIP.put(flowID, ip);
            flowProviderHost.put(flowID, host);
        }
        JsonArray result = new JsonArray();
        for (JsonObject obj : objects) {
            if (null == obj.get("flowID") || obj.get("flowID").isJsonNull()) continue;
            String flowID = obj.get("flowID").getAsString();
            long timestamp = obj.get("timestamp").getAsLong();
            Long endTime = (Long)flowLastTimestamp.get(flowID);
            if (endTime == null) continue;
            flowLastTimestamp.remove(flowID);
            JsonObject newObj = this.copy(obj);
            newObj.add("elapsed", (JsonElement)new JsonPrimitive((Number)(timestamp - endTime)));
            newObj.remove("type");
            newObj.add("types", this.gson.toJsonTree(flowTypes.get(flowID)));
            newObj.add("details", (JsonElement)new JsonPrimitive(baseURL + "flow/" + flowID));
            newObj.remove("host");
            newObj.remove("ip");
            if (flowConsumerHost.containsKey(flowID)) {
                newObj.add("consumer_host", (JsonElement)new JsonPrimitive((String)flowConsumerHost.get(flowID)));
                newObj.add("consumer_ip", (JsonElement)new JsonPrimitive((String)flowConsumerIP.get(flowID)));
            }
            if (flowProviderHost.containsKey(flowID)) {
                newObj.add("provider_host", (JsonElement)new JsonPrimitive((String)flowProviderHost.get(flowID)));
                newObj.add("provider_ip", (JsonElement)new JsonPrimitive((String)flowProviderIP.get(flowID)));
            }
            result.add((JsonElement)newObj);
        }
        return result;
    }

    private JsonObject copy(JsonObject obj) {
        return (JsonObject)this.parser.parse(obj.toString());
    }
}

