/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.flowidprocessor;

import java.util.logging.Logger;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdProtocolHeaderCodec;
import org.talend.esb.sam.agent.flowidprocessor.FlowIdSoapCodec;
import org.talend.esb.sam.agent.message.FlowIdHelper;

public class FlowIdProducerIn<T extends Message>
extends AbstractPhaseInterceptor<T> {
    private static final Logger LOG = Logger.getLogger(FlowIdProducerIn.class.getName());

    public FlowIdProducerIn() {
        super("pre-invoke");
    }

    public void handleMessage(T message) throws Fault {
        Message reqMsg;
        Exchange ex;
        String flowId = FlowIdHelper.getFlowId(message);
        if (flowId == null) {
            flowId = FlowIdProtocolHeaderCodec.readFlowId(message);
        }
        if (flowId == null) {
            flowId = FlowIdSoapCodec.readFlowId(message);
        }
        if (flowId == null && null != (ex = message.getExchange()) && null != (reqMsg = ex.getOutMessage()) && null != (flowId = FlowIdHelper.getFlowId(reqMsg))) {
            LOG.fine("Using FlowId '" + flowId + "' from exchange.");
        }
        if (flowId != null) {
            LOG.fine("FlowId '" + flowId + "' found in incoming message.");
        } else {
            flowId = ContextUtils.generateUUID();
            LOG.fine("No flowId found in incoming message! Generate new flowId " + flowId);
        }
        FlowIdHelper.setFlowId(message, flowId);
    }
}

