/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.eventadmin.translator.subject;

import org.talend.esb.sam.agent.eventadmin.translator.subject.AbstractSubjectExtractorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SamlTokenSubjectExtractor
extends AbstractSubjectExtractorHandler {
    public static final String SAML2_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:assertion";
    public static final String SAML2_SUBJECT_TAG = "NameID";
    public static final String SOAP_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_HEADER_TAG = "Header";
    private final StringBuilder answer = new StringBuilder();
    private boolean inSubjectTag = false;
    private boolean inSoapHeader = true;

    @Override
    public String getSubject() {
        return this.answer.toString();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isSoapHeaderTag(uri, localName)) {
            this.inSoapHeader = true;
        } else if (this.isSamlSubjectTag(uri, localName)) {
            this.inSubjectTag = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isSoapHeaderTag(uri, localName)) {
            if (!this.inSoapHeader) {
                throw new IllegalStateException("Missed startElement for Header");
            }
            this.inSoapHeader = false;
        } else if (this.isSamlSubjectTag(uri, localName)) {
            if (!this.inSubjectTag) {
                throw new IllegalStateException("Missed startElement for NameID");
            }
            this.inSubjectTag = false;
            throw new AbstractSubjectExtractorHandler.SubjectFoundException();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inSoapHeader && this.inSubjectTag) {
            this.answer.append(ch, start, length);
        }
    }

    private final boolean isSamlSubjectTag(String uri, String localName) {
        return SAML2_SUBJECT_TAG.equals(localName) && SAML2_NAMESPACE.equals(uri);
    }

    private final boolean isSoapHeaderTag(String uri, String localName) {
        return SOAP_HEADER_TAG.equals(localName) && SOAP_NAMESPACE.equals(uri);
    }
}

