/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.agent.wiretap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.talend.esb.sam.agent.wiretap.WireTapHelper;

public class WireTapIn
extends AbstractPhaseInterceptor<Message> {
    private boolean logMessageContent;
    private boolean logMessageContentOverride;

    public WireTapIn(boolean logMessageContent, boolean logMessageContentOverride) {
        super("receive");
        this.logMessageContent = logMessageContent;
        this.logMessageContentOverride = logMessageContentOverride;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMessage(Message message) throws Fault {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (WireTapHelper.isMessageContentToBeLogged(message, this.logMessageContent, this.logMessageContentOverride)) {
            if (null == is) {
                Reader reader = (Reader)message.getContent(Reader.class);
                if (null == reader) return;
                String encoding = (String)message.get((Object)Message.ENCODING);
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                try {
                    CachedOutputStream cos = new CachedOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)cos, encoding);
                    IOUtils.copy((Reader)reader, (Writer)writer, (int)1024);
                    reader.reset();
                    ((Writer)writer).flush();
                    message.setContent(InputStream.class, (Object)cos.getInputStream());
                    message.setContent(Reader.class, null);
                    message.setContent(CachedOutputStream.class, (Object)cos);
                    this.closeCachedOutputStream(message, cos);
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        reader.reset();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                CachedOutputStream cos = new CachedOutputStream();
                IOUtils.copyAndCloseInput((InputStream)is, (OutputStream)cos);
                message.setContent(InputStream.class, (Object)cos.getInputStream());
                message.setContent(CachedOutputStream.class, (Object)cos);
                this.closeCachedOutputStream(message, cos);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            CachedOutputStream cos = new CachedOutputStream();
            cos.write("[CONTENT LOGGING IS DISABLED]".getBytes(Charset.forName("UTF-8")));
            message.setContent(CachedOutputStream.class, (Object)cos);
            message.setContent(InputStream.class, (Object)is);
            this.closeCachedOutputStream(message, cos);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeCachedOutputStream(Message message, final CachedOutputStream cos) {
        message.getInterceptorChain().add((Interceptor)new AbstractPhaseInterceptor<Message>("post-invoke"){

            public void handleMessage(Message message) throws Fault {
                if (cos != null) {
                    try {
                        cos.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

