/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.schemavalidate;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.PolicyComponent;
import org.talend.esb.policy.schemavalidate.SchemaValidationPolicyBuilder;
import org.w3c.dom.Element;

public class SchemaValidationPolicy
implements Assertion {
    private ValidationType validationType = ValidationType.WSDLSchema;
    private AppliesToType appliesToType = AppliesToType.none;
    private MessageType messageType = MessageType.none;
    private String customSchemaPath = null;

    public SchemaValidationPolicy(Element element) {
        if (element.hasAttributeNS(null, "type")) {
            String type = element.getAttributeNS(null, "type");
            this.validationType = ValidationType.valueOf(type);
        }
        if (element.hasAttributeNS(null, "appliesTo")) {
            String applyTo = element.getAttributeNS(null, "appliesTo");
            this.appliesToType = AppliesToType.valueOf(applyTo);
        }
        if (element.hasAttributeNS(null, "message")) {
            String message = element.getAttributeNS(null, "message");
            this.messageType = MessageType.valueOf(message);
        }
        if (element.hasAttributeNS(null, "path")) {
            this.validationType = ValidationType.CustomSchema;
            this.customSchemaPath = element.getAttributeNS(null, "path");
        }
    }

    public SchemaValidationPolicy() {
    }

    public short getType() {
        return 5;
    }

    public boolean equal(PolicyComponent policyComponent) {
        return policyComponent == this;
    }

    public QName getName() {
        return SchemaValidationPolicyBuilder.SCHEMA_VALIDATION;
    }

    public boolean isOptional() {
        return false;
    }

    public boolean isIgnorable() {
        return false;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = writer.getPrefix("http://types.talend.com/policy/assertion/1.0");
        if (prefix == null) {
            prefix = "tpa";
            writer.setPrefix(prefix, "http://types.talend.com/policy/assertion/1.0");
        }
        writer.writeStartElement(prefix, "SchemaValidation", "http://types.talend.com/policy/assertion/1.0");
        writer.writeNamespace(prefix, "http://types.talend.com/policy/assertion/1.0");
        writer.writeAttribute(null, "type", this.validationType.name());
        writer.writeAttribute(null, "appliesTo", this.appliesToType.name());
        writer.writeAttribute(null, "message", this.messageType.name());
        if (this.validationType == ValidationType.CustomSchema) {
            writer.writeAttribute(null, "path", this.customSchemaPath);
        }
        writer.writeEndElement();
    }

    public PolicyComponent normalize() {
        return this;
    }

    public ValidationType getValidationType() {
        return this.validationType;
    }

    public void setValidationType(ValidationType validationType) {
        this.validationType = validationType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public AppliesToType getApplyToType() {
        return this.appliesToType;
    }

    public void setAppliesToType(AppliesToType appliesToType) {
        this.appliesToType = appliesToType;
    }

    public String getCustomSchemaPath() {
        return this.customSchemaPath;
    }

    public void setCustomSchemaPath(String customSchemaPath) {
        this.customSchemaPath = customSchemaPath;
    }

    public static enum MessageType {
        request,
        response,
        all,
        none;

    }

    public static enum AppliesToType {
        consumer,
        provider,
        always,
        none;

    }

    public static enum ValidationType {
        WSDLSchema,
        CustomSchema;

    }
}

