/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.compression.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.neethi.Assertion;
import org.talend.esb.policy.compression.impl.CompressionAssertion;
import org.talend.esb.policy.compression.impl.CompressionPolicyBuilder;
import org.talend.esb.policy.compression.impl.internal.CompressionConstants;
import org.talend.esb.policy.compression.impl.internal.CompressionHelper;

public class CompressionOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(CompressionOutInterceptor.class);
    private int threshold = CompressionConstants.TRESHOLD_ATTRIBUTE_DEFAULT;

    public CompressionOutInterceptor() {
        super("prepare-send");
        this.addAfter(MessageSenderInterceptor.class.getName());
    }

    public CompressionOutInterceptor(int threshold) {
        super("prepare-send");
        this.addAfter(MessageSenderInterceptor.class.getName());
        this.threshold = threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void handleMessage(Message message) throws Fault {
        try {
            Assertion a;
            AssertionInfo ai = CompressionPolicyBuilder.getAssertion(message);
            if (ai != null && (a = ai.getAssertion()) instanceof CompressionAssertion) {
                this.setThreshold(((CompressionAssertion)a).getThreshold());
            }
            this.wrapOriginalOutputStream(message);
            if (ai != null) {
                ai.setAsserted(true);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    public void wrapOriginalOutputStream(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        CachedOutputStream wrapper = new CachedOutputStream();
        CompressionCachedOutputStreamCallback callback = new CompressionCachedOutputStreamCallback(os, this.threshold, message);
        wrapper.registerCallback((CachedOutputStreamCallback)callback);
        message.setContent(OutputStream.class, (Object)wrapper);
    }

    static class GZipThresholdOutputStream
    extends AbstractThresholdOutputStream {
        Message message;
        private boolean thresholdReached = false;

        public GZipThresholdOutputStream(int t, OutputStream orig, Message msg) {
            super(t);
            this.wrappedStream = orig;
            this.message = msg;
        }

        public void thresholdNotReached() {
            this.thresholdReached = false;
            LOG.fine("Message is smaller than compression threshold, not compressing.");
        }

        public void thresholdReached() throws IOException {
            this.thresholdReached = true;
            LOG.fine("Compressing message.");
            GZIPOutputStream zipOutput = new GZIPOutputStream(this.wrappedStream);
            this.wrappedStream = zipOutput;
        }

        public boolean isThresholdReached() {
            return this.thresholdReached;
        }
    }

    public static class CompressionCachedOutputStreamCallback
    implements CachedOutputStreamCallback {
        private final OutputStream origOutStream;
        private final int threshold;
        private final Message message;

        public CompressionCachedOutputStreamCallback(OutputStream os, int threshold, Message message) {
            this.origOutStream = os;
            this.threshold = threshold;
            this.message = message;
        }

        public void onFlush(CachedOutputStream wrapper) {
        }

        public String getEncoding() {
            return "base64";
        }

        public String getAlgoritm() {
            return "gzip";
        }

        public void onClose(CachedOutputStream wrapper) {
            block17: {
                try {
                    InputStream wrappedIS = wrapper.getInputStream();
                    if (MessageUtils.isFault((Message)this.message)) {
                        wrappedIS.reset();
                        IOUtils.copy((InputStream)wrappedIS, (OutputStream)this.origOutStream);
                        break block17;
                    }
                    CachedOutputStream soapBodyContent = new CachedOutputStream();
                    Scanner scanner = new Scanner(wrappedIS);
                    MatchResult bodyPosition = null;
                    try {
                        bodyPosition = CompressionHelper.loadSoapBodyContent((OutputStream)soapBodyContent, scanner, CompressionConstants.SOAP_BODY_PATTERN);
                        if (bodyPosition == null) {
                            throw new RuntimeException("Compression: SOAP body is not found");
                        }
                    }
                    catch (XMLStreamException e) {
                        throw new Fault("Can not load SOAP Body content for compression", LOG, (Throwable)e, new Object[]{e.getMessage()});
                    }
                    CachedOutputStream compressedSoapBody = new CachedOutputStream();
                    GZipThresholdOutputStream compressor = new GZipThresholdOutputStream(this.threshold, (OutputStream)compressedSoapBody, this.message);
                    IOUtils.copy((InputStream)soapBodyContent.getInputStream(), (OutputStream)((Object)compressor));
                    compressor.flush();
                    compressor.close();
                    if (compressor.isThresholdReached()) {
                        byte[] encodedBodyBytes = new Base64().encode(compressedSoapBody.getBytes());
                        CompressionHelper.replaceBodyInSOAP(wrapper.getBytes(), bodyPosition, new ByteArrayInputStream(encodedBodyBytes), this.origOutStream, CompressionConstants.getCompressionWrapperStartTag(this.getAlgoritm(), this.getEncoding()), CompressionConstants.getCompressionWrapperEndTag(), false);
                    } else {
                        wrappedIS.reset();
                        IOUtils.copy((InputStream)wrappedIS, (OutputStream)this.origOutStream);
                    }
                }
                catch (Exception e) {
                    throw new Fault("Soap Body compression failed", LOG, (Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    try {
                        this.origOutStream.flush();
                        this.origOutStream.close();
                    }
                    catch (IOException e) {
                        LOG.warning("Cannot close stream after compression: " + e.getMessage());
                    }
                    catch (IllegalStateException e) {
                        LOG.log(Level.SEVERE, "Irregular attempt at closing output stream after compression", e);
                    }
                }
            }
        }
    }
}

