/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.policy.compression.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.talend.esb.policy.compression.impl.CompressionAssertion;
import org.talend.esb.policy.compression.impl.CompressionPolicyBuilder;
import org.talend.esb.policy.compression.impl.internal.CompressionConstants;
import org.talend.esb.policy.compression.impl.internal.CompressionHelper;

public class CompressionInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(CompressionInInterceptor.class);

    public CompressionInInterceptor() {
        super("receive");
        this.addBefore(AttachmentInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        try {
            this.decompressMessage(message);
            this.confirmPolicyProcessing(message);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    protected void confirmPolicyProcessing(Message message) {
        Collection ais;
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        if (aim != null && (ais = (Collection)aim.get((Object)CompressionPolicyBuilder.COMPRESSION)) != null) {
            for (AssertionInfo ai : ais) {
                if (!(ai.getAssertion() instanceof CompressionAssertion)) continue;
                ai.setAsserted(true);
            }
        }
    }

    public void decompressMessage(Message message) throws Fault {
        if (this.isGET(message)) {
            return;
        }
        final CachedOutputStream cache = new CachedOutputStream();
        final CachedOutputStream decompressedSoapMessage = new CachedOutputStream();
        try {
            LOG.fine("Uncompressing response");
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is == null) {
                return;
            }
            IOUtils.copyAndCloseInput((InputStream)is, (OutputStream)cache);
            CachedOutputStream soapBodyContent = new CachedOutputStream();
            Scanner scanner = new Scanner(cache.getInputStream());
            MatchResult bodyPosition = null;
            try {
                bodyPosition = CompressionHelper.loadSoapBodyContent((OutputStream)soapBodyContent, scanner, CompressionConstants.COMPRESSED_SOAP_BODY_PATTERN);
            }
            catch (XMLStreamException e) {
                throw new Fault("Can not read compressed SOAP Body", LOG, (Throwable)e, new Object[]{e.getMessage()});
            }
            if (bodyPosition == null) {
                message.setContent(InputStream.class, (Object)cache.getInputStream());
            } else {
                byte[] base64DecodedSoapBody = new Base64().decode(soapBodyContent.getBytes());
                GZIPInputStream decompressedBody = new GZIPInputStream(new ByteArrayInputStream(base64DecodedSoapBody));
                CompressionHelper.replaceBodyInSOAP(cache.getBytes(), bodyPosition, decompressedBody, (OutputStream)decompressedSoapMessage, null, null, true);
                message.setContent(InputStream.class, (Object)decompressedSoapMessage.getInputStream());
            }
            if (message.getInterceptorChain() != null) {
                message.getInterceptorChain().add((Interceptor)new AbstractPhaseInterceptor<Message>("post-invoke"){

                    public void handleMessage(Message message) throws Fault {
                        CompressionInInterceptor.this.closeCacheStreams(cache, decompressedSoapMessage);
                    }
                });
            }
        }
        catch (Exception ex) {
            this.closeCacheStreams(cache, decompressedSoapMessage);
            throw new Fault("SOAP Body decompression failed", LOG, (Throwable)ex);
        }
    }

    private void closeCacheStreams(CachedOutputStream cache, CachedOutputStream decompressedSoapMessage) {
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (decompressedSoapMessage != null) {
            try {
                decompressedSoapMessage.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

