/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.talend.esb.mep.requestcallback.feature.Configuration;
import org.talend.esb.mep.requestcallback.feature.ConfigurationInitializer;

public class ConfigurationUpdater
implements ManagedService {
    private static final Manager MANAGER = new Manager();
    private final Configuration configuration;
    private String configIdentifier = null;
    private ServiceRegistration<?> registration = null;

    public ConfigurationUpdater(Configuration configuration) {
        this.configuration = configuration;
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        this.configuration.updateDynamicConfiguration(properties, true);
    }

    public synchronized void register(BundleContext bundleContext) {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.configIdentifier = this.resolveConfigIdentifier();
        this.registration = this.register(bundleContext, this.configIdentifier);
    }

    public synchronized void unregister() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public static boolean addUpdater(ConfigurationUpdater updater) {
        return MANAGER.addUpdater(updater);
    }

    public static boolean removeUpdater(ConfigurationUpdater updater) {
        return MANAGER.removeUpdater(updater);
    }

    public static void activateUpdaters(BundleContext bundleContext) {
        MANAGER.activateUpdaters(bundleContext);
    }

    public static void deactivateUpdaters() {
        MANAGER.deactivateUpdaters();
    }

    private String resolveConfigIdentifier() {
        String key;
        if (this.configuration.getAlternateConfigurationIdentifier() == null) {
            return this.configuration.getConfigurationIdentifier();
        }
        Configuration baseConfig = ConfigurationInitializer.resolveConfiguration(null);
        Configuration.PidMode pidMode = baseConfig.getPidModeProperty(key = this.configuration.getConfigurationName().toString() + ".pidMode");
        if (pidMode == null) {
            pidMode = baseConfig.getPidModeProperty("default.pidMode");
        }
        if (pidMode == Configuration.PidMode.FULL_NAME) {
            return this.configuration.getConfigurationIdentifier();
        }
        return this.configuration.getAlternateConfigurationIdentifier();
    }

    private ServiceRegistration<?> register(BundleContext bundleContext, String servicePid) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.pid", servicePid);
        return bundleContext.registerService(ManagedService.class.getName(), (Object)this, properties);
    }

    private static void registerUpdaterFor(Configuration configuration) {
        ConfigurationUpdater updater = new ConfigurationUpdater(configuration);
        MANAGER.addUpdater(updater);
    }

    private static void setupListener() {
        ConfigurationInitializer.addConfigurationCreationListener(new ConfigurationInitializer.ConfigurationCreationListener(){

            @Override
            public void configurationCreated(Configuration configuration) {
                ConfigurationUpdater.registerUpdaterFor(configuration);
            }
        }, true);
    }

    static {
        ConfigurationUpdater.setupListener();
    }

    private static final class Manager {
        private final List<ConfigurationUpdater> updaters = new LinkedList<ConfigurationUpdater>();
        private BundleContext bundleContext = null;

        public synchronized boolean addUpdater(ConfigurationUpdater updater) {
            if (this.updaters.add(updater)) {
                if (this.bundleContext != null) {
                    updater.register(this.bundleContext);
                }
                return true;
            }
            return false;
        }

        public synchronized boolean removeUpdater(ConfigurationUpdater updater) {
            if (this.updaters.remove(updater)) {
                updater.unregister();
                return true;
            }
            return false;
        }

        public synchronized void activateUpdaters(BundleContext bundleContext) {
            if (bundleContext == null) {
                return;
            }
            this.deactivateUpdaters();
            for (ConfigurationUpdater updater : this.updaters) {
                updater.register(bundleContext);
            }
            this.bundleContext = bundleContext;
        }

        public synchronized void deactivateUpdaters() {
            if (this.bundleContext == null) {
                return;
            }
            for (ConfigurationUpdater updater : this.updaters) {
                updater.unregister();
            }
            this.bundleContext = null;
        }
    }
}

