/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl;

import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.talend.esb.mep.requestcallback.feature.CallContext;
import org.talend.esb.mep.requestcallback.feature.RequestCallbackFeature;
import org.talend.esb.sam.agent.message.FlowIdHelper;

public class RequestCallbackOutInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    public RequestCallbackOutInterceptor() {
        super("pre-logical");
        this.addBefore(MAPAggregator.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        Exchange e = message.getExchange();
        if (!e.isOneWay()) {
            return;
        }
        this.doHandleSoapMessage(message);
    }

    private void doHandleSoapMessage(SoapMessage message) throws Fault {
        Object callbackEndpoint = message.getContextualProperty("org.talend.esb.mep.requestcallback.CallbackEndpoint");
        if (callbackEndpoint != null) {
            String callbackEndpointAddress;
            if (callbackEndpoint instanceof String) {
                callbackEndpointAddress = (String)callbackEndpoint;
            } else if (callbackEndpoint instanceof EndpointImpl) {
                callbackEndpointAddress = ((EndpointImpl)callbackEndpoint).getAddress();
            } else {
                throw new IllegalArgumentException("Unsupported type of endpoint. ");
            }
            this.doHandleRequestSoapMessage(message, callbackEndpointAddress);
            return;
        }
        CallContext ctx = (CallContext)message.getContextualProperty("org.talend.esb.mep.requestcallback.CallContext");
        if (ctx != null) {
            this.doHandleCallbackSoapMessage(message, ctx);
            return;
        }
    }

    private void doHandleRequestSoapMessage(SoapMessage message, String callbackEndpoint) throws Fault {
        String callId = ContextUtils.generateUUID();
        message.getHeaders().add(RequestCallbackOutInterceptor.createHeader(RequestCallbackFeature.CALL_ID_HEADER_NAME, callId));
        Map<String, Object> requestInfo = RequestCallbackOutInterceptor.getCallInfo(message);
        if (requestInfo != null) {
            requestInfo.put("callId", callId);
        }
        this.aggregateAddressing(message, callbackEndpoint, null);
    }

    private void doHandleCallbackSoapMessage(SoapMessage message, CallContext callContext) throws Fault {
        String flowId;
        String callId = callContext.getCallId();
        String correlationID = callContext.getCorrelationId();
        String callbackId = ContextUtils.generateUUID();
        List headers = message.getHeaders();
        if (correlationID != null) {
            message.getHeaders().add(RequestCallbackOutInterceptor.createHeader(RequestCallbackFeature.CORRELATION_ID_HEADER_NAME, correlationID));
        }
        message.getHeaders().add(RequestCallbackOutInterceptor.createHeader(RequestCallbackFeature.CALL_ID_HEADER_NAME, callId));
        headers.add(RequestCallbackOutInterceptor.createHeader(RequestCallbackFeature.CALLBACK_ID_HEADER_NAME, callbackId));
        Map<String, Object> requestInfo = RequestCallbackOutInterceptor.getCallInfo(message);
        if (requestInfo != null) {
            requestInfo.put("callId", callId);
            requestInfo.put("callbackId", callbackId);
        }
        if ((flowId = callContext.getFlowId()) != null && !flowId.isEmpty()) {
            FlowIdHelper.setFlowId((Message)message, (String)flowId);
        }
        this.aggregateAddressing(message, null, callContext.getRequestId());
        RequestCallbackOutInterceptor.propagateRequestorCertificate((Message)message, callContext);
    }

    private void aggregateAddressing(SoapMessage message, String callbackEndpoint, String relatesTo) {
        EndpointReferenceType replyTo;
        AddressingProperties maps = RequestCallbackOutInterceptor.initAddressingProperties(message);
        if (callbackEndpoint != null && ((replyTo = maps.getReplyTo()) == null || ContextUtils.isGenericAddress((EndpointReferenceType)replyTo))) {
            EndpointReferenceType replyToRef = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(callbackEndpoint);
            replyToRef.setAddress(address);
            maps.setReplyTo(replyToRef);
        }
    }

    private static Header createHeader(QName headerName, String value) throws Fault {
        try {
            return new Header(headerName, (Object)value, (DataBinding)new JAXBDataBinding(new Class[]{String.class}));
        }
        catch (JAXBException e) {
            throw new Fault((Throwable)e);
        }
    }

    private static AddressingProperties initAddressingProperties(SoapMessage message) {
        AddressingProperties maps = (AddressingProperties)message.getContextualProperty("javax.xml.ws.addressing.context");
        if (maps == null) {
            maps = new AddressingProperties();
            message.put("javax.xml.ws.addressing.context", (Object)maps);
        }
        return maps;
    }

    private static Map<String, Object> getCallInfo(SoapMessage message) {
        return (Map)message.getContextualProperty("org.talend.esb.mep.requestcallback.CallInfo");
    }

    private static void propagateRequestorCertificate(Message message, CallContext callContext) {
        if (callContext.getRequestorSignatureCertificate() != null) {
            message.put((Object)"security.encryption.certificate", (Object)callContext.getRequestorSignatureCertificate());
        }
    }
}

