/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.talend.esb.mep.requestcallback.feature.Configuration;
import org.talend.esb.mep.requestcallback.impl.AbstractConfiguration;

public class ConfigurationImpl
extends AbstractConfiguration {
    private static final Logger LOGGER = LogUtils.getL7dLogger(ConfigurationImpl.class);
    private Map<String, Object> userMap = null;
    private Map<String, Object> dynamicMap = null;
    private Map<String, Object> staticMap = null;
    private Map<String, Object> mergedMap = null;
    private Configuration.ChangeListener changeListener = null;
    private final QName configurationName;
    private final String configurationId;
    private final String alternateConfigId;

    public ConfigurationImpl(QName configurationName) {
        String cfgid;
        this.configurationName = configurationName;
        this.configurationId = ConfigurationImpl.asConfigIdentifier(configurationName);
        this.alternateConfigId = configurationName == null ? null : (this.configurationId.equals(cfgid = ConfigurationImpl.asConfigIdentifier(configurationName.getLocalPart())) ? null : cfgid);
    }

    @Override
    public synchronized int size() {
        return this.getMergedMap().size();
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.mergedMap != null) {
            return this.mergedMap.isEmpty();
        }
        if (this.staticMap != null && !this.staticMap.isEmpty()) {
            return false;
        }
        if (this.dynamicMap != null && !this.dynamicMap.isEmpty()) {
            return false;
        }
        return this.userMap == null || this.userMap.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (this.mergedMap != null) {
            return this.mergedMap.containsKey(key);
        }
        if (this.staticMap != null && this.staticMap.containsKey(key)) {
            return true;
        }
        if (this.dynamicMap != null && this.dynamicMap.containsKey(key)) {
            return true;
        }
        return this.userMap != null && this.userMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.getMergedMap().containsValue(value);
    }

    @Override
    public synchronized Object get(Object key) {
        Object res;
        if (this.mergedMap != null) {
            return this.mergedMap.get(key);
        }
        if (this.userMap != null && (res = this.userMap.get(key)) != null) {
            return res;
        }
        if (this.dynamicMap != null && (res = this.dynamicMap.get(key)) != null) {
            return res;
        }
        if (this.staticMap != null && (res = this.staticMap.get(key)) != null) {
            return res;
        }
        return null;
    }

    @Override
    public synchronized Object put(String key, Object value) {
        if (this.userMap == null) {
            this.userMap = new HashMap<String, Object>();
        }
        this.mergedMap = null;
        return this.userMap.put(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        if (this.userMap == null) {
            return null;
        }
        Object result = this.userMap.remove(key);
        if (result != null) {
            this.mergedMap = null;
            if (this.userMap.isEmpty()) {
                this.userMap = null;
            }
        }
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends Object> m) {
        if (this.userMap == null) {
            this.userMap = new HashMap<String, Object>();
        }
        this.mergedMap = null;
        this.userMap.putAll(m);
    }

    @Override
    public synchronized void clear() {
        if (this.userMap != null) {
            this.userMap = null;
            this.mergedMap = null;
        }
    }

    @Override
    public synchronized Set<String> keySet() {
        return this.getMergedMap().keySet();
    }

    @Override
    public synchronized Collection<Object> values() {
        return this.getMergedMap().values();
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> entrySet() {
        return this.getMergedMap().entrySet();
    }

    @Override
    public synchronized void updateDynamicConfiguration(Map<?, ?> updateMap, boolean replaceCurrent) {
        if (updateMap == null || updateMap.isEmpty()) {
            if (replaceCurrent) {
                this.mergedMap = null;
                this.dynamicMap = null;
                if (this.changeListener != null) {
                    this.changeListener.changed(this);
                }
            }
            return;
        }
        this.mergedMap = null;
        Map<Object, Object> dynMap = this.dynamicMap == null || replaceCurrent ? new HashMap() : this.dynamicMap;
        for (Map.Entry<?, ?> entry : updateMap.entrySet()) {
            dynMap.put(entry.getKey().toString(), entry.getValue());
        }
        this.dynamicMap = dynMap;
        if (this.changeListener != null) {
            this.changeListener.changed(this);
        }
    }

    @Override
    public synchronized void updateDynamicConfiguration(Dictionary<?, ?> updateDict, boolean replaceCurrent) {
        if (updateDict == null || updateDict.isEmpty()) {
            if (replaceCurrent) {
                this.mergedMap = null;
                this.dynamicMap = null;
                if (this.changeListener != null) {
                    this.changeListener.changed(this);
                }
            }
            return;
        }
        this.mergedMap = null;
        Map<Object, Object> dynMap = this.dynamicMap == null || replaceCurrent ? new HashMap() : this.dynamicMap;
        Enumeration<?> keys = updateDict.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            dynMap.put(key.toString(), updateDict.get(key));
        }
        this.dynamicMap = dynMap;
        if (this.changeListener != null) {
            this.changeListener.changed(this);
        }
    }

    @Override
    public synchronized void refreshStaticConfiguration() {
        String sysprop;
        this.staticMap = null;
        this.mergedMap = null;
        String cfgFileName = this.configurationId + ".properties";
        String altFileName = this.alternateConfigId == null ? null : this.alternateConfigId + ".properties";
        Properties staticProps = null;
        Properties loadedProps = null;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(cfgFileName);
        loadedProps = ConfigurationImpl.loadProps(staticProps, is);
        if (loadedProps == null && altFileName != null) {
            is = this.getClass().getClassLoader().getResourceAsStream(altFileName);
            loadedProps = ConfigurationImpl.loadProps(staticProps, is);
        }
        if (loadedProps != null) {
            staticProps = loadedProps;
        }
        if ((sysprop = System.getProperty("org.talend.esb.mep.requestcallback.configuration")) != null) {
            block21: {
                try {
                    if (sysprop.startsWith("file:/") || sysprop.contains("://")) {
                        URL configURL;
                        String cfgURLName = sysprop.endsWith("/") ? sysprop + cfgFileName : sysprop + "/" + cfgFileName;
                        try {
                            configURL = new URL(cfgURLName);
                            is = configURL.openStream();
                        }
                        catch (Exception e) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, "Exception caught: ", e);
                            }
                            is = null;
                        }
                        loadedProps = ConfigurationImpl.loadProps(staticProps, is);
                        if (loadedProps != null || altFileName == null) break block21;
                        cfgURLName = sysprop.endsWith("/") ? sysprop + altFileName : sysprop + "/" + altFileName;
                        try {
                            configURL = new URL(cfgURLName);
                            is = configURL.openStream();
                        }
                        catch (Exception e) {
                            if (LOGGER.isLoggable(Level.FINER)) {
                                LOGGER.log(Level.FINER, "Exception caught: ", e);
                            }
                            is = null;
                        }
                        loadedProps = ConfigurationImpl.loadProps(staticProps, is);
                        break block21;
                    }
                    File configDir = new File(sysprop);
                    if (configDir.canRead() && configDir.isDirectory()) {
                        File cfgFile = new File(configDir, cfgFileName);
                        if (cfgFile.isFile() && cfgFile.canRead()) {
                            is = new FileInputStream(cfgFile);
                            loadedProps = ConfigurationImpl.loadProps(staticProps, is);
                        } else if (altFileName != null && (cfgFile = new File(configDir, altFileName)).isFile() && cfgFile.canRead()) {
                            is = new FileInputStream(cfgFile);
                            loadedProps = ConfigurationImpl.loadProps(staticProps, is);
                        }
                    }
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Exception caught: ", e);
                    }
                    loadedProps = null;
                }
            }
            if (loadedProps != null) {
                staticProps = loadedProps;
            }
        }
        if (staticProps != null) {
            HashMap<String, Object> statMap = new HashMap<String, Object>();
            for (Map.Entry<Object, Object> e : staticProps.entrySet()) {
                statMap.put(e.getKey().toString(), e.getValue());
            }
            this.staticMap = statMap;
        }
        if (this.changeListener != null) {
            this.changeListener.changed(this);
        }
    }

    @Override
    public synchronized void fillProperties(String prefix, Map<? super String, Object> properties) {
        if (this.mergedMap != null) {
            ConfigurationImpl.transferProperties(prefix, this.mergedMap, properties);
            return;
        }
        if (this.staticMap != null) {
            ConfigurationImpl.transferProperties(prefix, this.staticMap, properties);
        }
        if (this.dynamicMap != null) {
            ConfigurationImpl.transferProperties(prefix, this.dynamicMap, properties);
        }
        if (this.userMap != null) {
            ConfigurationImpl.transferProperties(prefix, this.userMap, properties);
        }
    }

    @Override
    public synchronized void fillExpandedProperties(String prefix, Map<? super String, Object> properties) {
        Map<String, Object> source = this.getMergedMap();
        ConfigurationImpl.transferExpandedProperties(prefix, source, properties, source);
    }

    @Override
    public QName getConfigurationName() {
        return this.configurationName;
    }

    @Override
    public String getConfigurationIdentifier() {
        return this.configurationId;
    }

    @Override
    public String getAlternateConfigurationIdentifier() {
        return this.alternateConfigId;
    }

    @Override
    public Configuration.ChangeListener getChangeListener() {
        return this.changeListener;
    }

    @Override
    public void setChangeListener(Configuration.ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    private Map<String, Object> getMergedMap() {
        if (this.mergedMap == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            if (this.staticMap != null) {
                result.putAll(this.staticMap);
            }
            if (this.dynamicMap != null) {
                result.putAll(this.dynamicMap);
            }
            if (this.userMap != null) {
                result.putAll(this.userMap);
            }
            this.mergedMap = Collections.unmodifiableMap(result);
        }
        return this.mergedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProps(Properties props, InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            Properties result = props == null ? new Properties() : props;
            result.load(is);
            Properties properties = result;
            return properties;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            Properties properties = null;
            return properties;
        }
        finally {
            block13: {
                try {
                    is.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINER)) break block13;
                    LOGGER.log(Level.FINER, "Exception caught: ", e);
                }
            }
        }
    }
}

