/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.feature;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLManager;
import org.talend.esb.mep.requestcallback.impl.CallbackActionInterceptor;
import org.talend.esb.mep.requestcallback.impl.RequestCallbackInInterceptor;
import org.talend.esb.mep.requestcallback.impl.RequestCallbackOutInterceptor;
import org.talend.esb.mep.requestcallback.impl.wsdl.CallbackExtension;
import org.talend.esb.mep.requestcallback.impl.wsdl.PLType;

public class RequestCallbackFeature
extends AbstractFeature {
    public static final String REQUEST_CALLBACK_CONFIGURATION_OSGI_PROPERTY = "org.talend.esb.mep.requestcallback";
    public static final String REQUEST_CALLBACK_CONFIGURATION_SYSTEM_PROPERTY = "org.talend.esb.mep.requestcallback.configuration";
    public static final String REQUEST_CALLBACK_CONFIGURATION_RESOURCE = "org.talend.esb.mep.requestcallback.Configuration.properties";
    public static final String CALL_ID_NAME = "callId";
    public static final String CALLBACK_ID_NAME = "callbackId";
    public static final String CORRELATION_ID_NAME = "correlationId";
    public static final QName CORRELATION_ID_HEADER_NAME = new QName("http://www.talend.com/esb/sam/correlationId/v1", "correlationId");
    public static final QName CALL_ID_HEADER_NAME = new QName("http://www.talend.com/esb/requestcallback", "callId");
    public static final QName CALLBACK_ID_HEADER_NAME = new QName("http://www.talend.com/esb/requestcallback", "callbackId");
    public static final String CALLCONTEXT_PROPERTY_NAME = "org.talend.esb.mep.requestcallback.CallContext";
    public static final String CALLBACK_ENDPOINT_PROPERTY_NAME = "org.talend.esb.mep.requestcallback.CallbackEndpoint";
    public static final String CALL_INFO_PROPERTY_NAME = "org.talend.esb.mep.requestcallback.CallInfo";
    private static final Logger LOG = Logger.getLogger(RequestCallbackFeature.class.getName());

    public void initialize(Client client, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Request-Callback feature for bus " + bus + " and client " + client);
        }
        RequestCallbackFeature.applyWsdlExtensions(bus);
        this.initializeProvider((InterceptorProvider)client, bus);
    }

    public static void applyWsdlExtensions(Bus bus) {
        ExtensionRegistry registry = ((WSDLManager)bus.getExtension(WSDLManager.class)).getExtensionRegistry();
        try {
            JAXBExtensionHelper.addExtensions((Bus)bus, (ExtensionRegistry)registry, Definition.class, PLType.class);
            JAXBExtensionHelper.addExtensions((Bus)bus, (ExtensionRegistry)registry, Binding.class, CallbackExtension.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to add WSDL JAXB extensions", e);
        }
    }

    public void initialize(Server server, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Request-Callback feature for bus " + bus + " and server " + server);
        }
        this.initializeProvider((InterceptorProvider)server.getEndpoint(), bus);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Resolving bus extensions for Request-Callback feature");
        }
        WSAddressingFeature addressing = new WSAddressingFeature();
        addressing.setAddressingRequired(true);
        addressing.initialize(provider, bus);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing interceptors for Request-Callback feature");
        }
        RequestCallbackInInterceptor inInterceptor = new RequestCallbackInInterceptor();
        CallbackActionInterceptor cbInterceptor = new CallbackActionInterceptor();
        RequestCallbackOutInterceptor outInterceptor = new RequestCallbackOutInterceptor();
        provider.getInInterceptors().add(inInterceptor);
        provider.getInInterceptors().add(cbInterceptor);
        provider.getOutInterceptors().add(outInterceptor);
    }
}

