/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.beans;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.NavigableMap;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class JmsUriConfiguration {
    private String variant = null;
    private String destinationName = null;
    private final NavigableMap<String, String> parameters = new TreeMap<String, String>();
    private UriEncoding uriEncode = UriEncoding.PARTIAL;
    private boolean validate = true;

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        if (variant == null) {
            this.variant = null;
            return;
        }
        if ("jndi".equalsIgnoreCase(variant)) {
            this.variant = "jndi";
            return;
        }
        if ("jndi-topic".equalsIgnoreCase(variant)) {
            this.variant = "jndi-topic";
            return;
        }
        if ("queue".equalsIgnoreCase(variant)) {
            this.variant = "queue";
            return;
        }
        if ("topic".equalsIgnoreCase(variant)) {
            this.variant = "topic";
            return;
        }
        if (this.validate) {
            throw new IllegalArgumentException("Unknown JMS variant " + variant);
        }
        this.variant = variant;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    @Deprecated
    public boolean isEncode() {
        return this.uriEncode != UriEncoding.NONE;
    }

    @Deprecated
    public void setEncode(boolean encode) {
        this.uriEncode = encode ? UriEncoding.PARTIAL : UriEncoding.NONE;
    }

    public UriEncoding getUriEncode() {
        return this.uriEncode;
    }

    public void setUriEncode(UriEncoding uriEncode) {
        this.uriEncode = uriEncode;
    }

    public void setUriEncode(String uriEncodeValue) {
        this.uriEncode = JmsUriConfiguration.toUriEncoding(uriEncodeValue);
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public String putParameter(String name, String value) {
        return this.parameters.put(name, value);
    }

    public NavigableMap<String, String> getParameters() {
        return this.parameters;
    }

    public NavigableMap<String, String> getJndiEnvironmentParameters() {
        return this.parameters.subMap("jndi-", false, "jndi.", false);
    }

    public void applyJmsUri(String jmsUri) {
        if (jmsUri == null || jmsUri.length() == 0 || "jms://".equalsIgnoreCase(jmsUri)) {
            return;
        }
        int ndx = this.extractPrefix(jmsUri);
        ndx = this.extractVariant(jmsUri, ndx);
        ndx = this.extractDestinationName(jmsUri, ndx);
        ndx = this.extractParameters(jmsUri, ndx);
        if (this.validate && ndx >= 0) {
            throw new IllegalArgumentException("Fragment not supported in JMS URI ");
        }
    }

    public void clear() {
        this.variant = null;
        this.destinationName = null;
        this.parameters.clear();
    }

    public String toString() {
        if (this.variant == null || this.variant.isEmpty() || this.destinationName == null || this.destinationName.isEmpty()) {
            return "jms://";
        }
        StringBuilder buf = new StringBuilder("jms:");
        buf.append(this.variant).append(':').append(this.encode(this.destinationName));
        if (!this.parameters.isEmpty()) {
            buf.append('?');
            boolean addDelimiter = false;
            for (Map.Entry param : this.parameters.entrySet()) {
                if (addDelimiter) {
                    buf.append('&');
                } else {
                    addDelimiter = true;
                }
                buf.append(this.encode((String)param.getKey()));
                String value = (String)param.getValue();
                if (value == null || value.length() <= 0) continue;
                buf.append('=').append(this.encode(value));
            }
        }
        return buf.toString();
    }

    public static UriEncoding toUriEncoding(String uriEncodeValue) {
        if (uriEncodeValue == null) {
            throw new IllegalArgumentException("Invalid URI encoding option value: null");
        }
        if ("none".equalsIgnoreCase(uriEncodeValue) || "false".equalsIgnoreCase(uriEncodeValue) || "no".equalsIgnoreCase(uriEncodeValue) || "n".equalsIgnoreCase(uriEncodeValue) || "off".equalsIgnoreCase(uriEncodeValue)) {
            return UriEncoding.NONE;
        }
        if ("partial".equalsIgnoreCase(uriEncodeValue) || "true".equalsIgnoreCase(uriEncodeValue) || "yes".equalsIgnoreCase(uriEncodeValue) || "y".equalsIgnoreCase(uriEncodeValue) || "on".equalsIgnoreCase(uriEncodeValue)) {
            return UriEncoding.PARTIAL;
        }
        if ("full".equalsIgnoreCase(uriEncodeValue)) {
            return UriEncoding.FULL;
        }
        throw new IllegalArgumentException("Invalid URI encoding option value: " + uriEncodeValue + ". ");
    }

    private int extractPrefix(String jmsUri) {
        int strLen = jmsUri.length();
        if (strLen < 4 || !"jms:".equalsIgnoreCase(jmsUri.substring(0, 4))) {
            throw new IllegalArgumentException("Not a JMS URI: " + jmsUri);
        }
        return strLen == 4 ? -1 : 4;
    }

    private int extractVariant(String jmsUri, int startIndex) {
        String v;
        if (startIndex < 0) {
            return -1;
        }
        int endIndex = jmsUri.indexOf(58, startIndex);
        String string = v = endIndex < 0 ? jmsUri.substring(startIndex) : jmsUri.substring(startIndex, endIndex);
        if (v.length() > 0) {
            this.setVariant(v);
        }
        return JmsUriConfiguration.currentEndIndex(endIndex, jmsUri.length());
    }

    private int extractDestinationName(String jmsUri, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        int strLen = jmsUri.length();
        int bracketLevel = 0;
        block5: for (int endIndex = startIndex; endIndex < strLen; ++endIndex) {
            switch (jmsUri.charAt(endIndex)) {
                case '?': {
                    if (bracketLevel > 0) continue block5;
                    String dName = this.decode(jmsUri.substring(startIndex, endIndex));
                    if (dName.length() > 0) {
                        this.destinationName = dName;
                    }
                    return JmsUriConfiguration.currentEndIndex(endIndex, strLen);
                }
                case '(': {
                    ++bracketLevel;
                    continue block5;
                }
                case ')': {
                    --bracketLevel;
                    continue block5;
                }
            }
        }
        String dName = this.decode(jmsUri.substring(startIndex));
        if (dName.length() > 0) {
            this.destinationName = dName;
        }
        return -1;
    }

    private int extractParameters(String jmsUri, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        int endIndex = jmsUri.indexOf(35, startIndex);
        String queryString = endIndex < 0 ? jmsUri.substring(startIndex) : jmsUri.substring(startIndex, endIndex);
        this.addParametersFromQueryString(queryString);
        return JmsUriConfiguration.currentEndIndex(endIndex, jmsUri.length());
    }

    private void addParametersFromQueryString(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return;
        }
        StringTokenizer params = new StringTokenizer(queryString, "&", false);
        while (params.hasMoreTokens()) {
            String key;
            String rawEntry = params.nextToken();
            int ndx = rawEntry.indexOf(61);
            if (ndx < 0) {
                key = this.decode(rawEntry);
                this.parameters.put(key, "");
                continue;
            }
            key = this.decode(rawEntry.substring(0, ndx));
            String value = this.decode(rawEntry.substring(ndx + 1));
            this.parameters.put(key, value);
        }
    }

    private String decode(String enc) {
        if (this.uriEncode == UriEncoding.NONE) {
            return enc;
        }
        try {
            return URLDecoder.decode(enc, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected Exception: ", e);
        }
    }

    private String encode(String enc) {
        if (this.uriEncode == UriEncoding.NONE) {
            return enc;
        }
        try {
            String result = URLEncoder.encode(enc, "UTF-8");
            return this.uriEncode == UriEncoding.FULL ? result : result.replace("%2F", "/").replace("%3A", ":").replace("%28", "(").replace("%29", ")").replace("%2C", ",").replace("%3D", "=");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected Exception: ", e);
        }
    }

    private static int currentEndIndex(int markIndex, int strlen) {
        if (markIndex < 0) {
            return -1;
        }
        int rawResult = markIndex + 1;
        return rawResult < strlen ? rawResult : -1;
    }

    public static enum UriEncoding {
        NONE,
        PARTIAL,
        FULL;

    }
}

