/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.mep.requestcallback.beans;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.transport.jms.JMSConfigFeature;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.talend.esb.mep.requestcallback.feature.CallContext;
import org.talend.esb.mep.requestcallback.feature.Configuration;

public class JmsConfigurator
implements InitializingBean {
    public static final String OVERRIDE_BY_URI_CONFIG = "override";
    private static final Logger LOGGER = LogUtils.getL7dLogger(JmsConfigurator.class);
    private QName serviceName;
    private String configurationPrefix;
    private String workPrefix;
    private Configuration configuration;
    private JMSConfiguration jmsConfiguration;
    private boolean jmsConfigured = false;

    public static JmsConfigurator create(Endpoint endpoint) {
        if (!(endpoint instanceof EndpointImpl)) {
            return null;
        }
        EndpointImpl ep = (EndpointImpl)endpoint;
        QName serviceName = ep.getServiceName();
        if (serviceName == null) {
            return null;
        }
        QName endpointName = ep.getEndpointName();
        String portName = endpointName == null ? null : endpointName.getLocalPart();
        JmsConfigurator result = new JmsConfigurator();
        result.setConfigurationPrefix(portName);
        result.setJmsConfiguration(new JMSConfiguration());
        result.setServiceName(serviceName);
        return result;
    }

    public static JmsConfigurator create(JaxWsServerFactoryBean factory) {
        if (factory == null) {
            return null;
        }
        QName serviceName = factory.getServiceName();
        if (serviceName == null) {
            return null;
        }
        QName endpointName = factory.getEndpointName();
        String portName = endpointName == null ? null : endpointName.getLocalPart();
        JmsConfigurator result = new JmsConfigurator();
        result.setConfigurationPrefix(portName);
        result.setJmsConfiguration(new JMSConfiguration());
        result.setServiceName(serviceName);
        return result;
    }

    public static JmsConfigurator create(Dispatch<?> dispatch) {
        QName endpointName;
        QName serviceName;
        if (!(dispatch instanceof DispatchImpl)) {
            return null;
        }
        DispatchImpl dsp = (DispatchImpl)dispatch;
        Client cl = dsp.getClient();
        try {
            serviceName = cl.getEndpoint().getService().getName();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            return null;
        }
        if (serviceName == null) {
            return null;
        }
        try {
            endpointName = cl.getEndpoint().getEndpointInfo().getName();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Exception caught: ", e);
            }
            endpointName = null;
        }
        String portName = endpointName == null ? null : endpointName.getLocalPart();
        JmsConfigurator result = new JmsConfigurator();
        result.setConfigurationPrefix(portName);
        result.setJmsConfiguration(new JMSConfiguration());
        result.setServiceName(serviceName);
        return result;
    }

    public Endpoint configureEndpoint(Endpoint endpoint) {
        if (this.jmsConfiguration == null || !(endpoint instanceof EndpointImpl) || this.serviceName == null && this.configuration == null) {
            return null;
        }
        if (!this.jmsConfigured) {
            this.setupJmsConfiguration();
        }
        EndpointImpl ei = (EndpointImpl)endpoint;
        JMSConfigFeature feature = new JMSConfigFeature();
        feature.setJmsConfig(this.jmsConfiguration);
        ArrayList<JMSConfigFeature> features = ei.getFeatures();
        if (features == null) {
            features = new ArrayList<JMSConfigFeature>();
        }
        features.add(feature);
        ei.setFeatures(features);
        return endpoint;
    }

    public Endpoint configureAndPublishEndpoint(Endpoint endpoint, String jmsAddress) {
        Endpoint result;
        String address = jmsAddress;
        if (OVERRIDE_BY_URI_CONFIG.equals(jmsAddress)) {
            String overrideAddress;
            if (this.configuration == null) {
                if (this.serviceName == null) {
                    return null;
                }
                this.configuration = CallContext.resolveConfiguration(this.serviceName);
            }
            if ((overrideAddress = this.getProperty("requestURI2010")) != null) {
                endpoint.publish(overrideAddress);
                return endpoint;
            }
            address = "jms://";
        }
        if ((result = this.configureEndpoint(endpoint)) != null) {
            result.publish(address);
        }
        return result;
    }

    public <T> Dispatch<T> configureDispatch(Dispatch<T> dispatch) {
        if (this.jmsConfiguration == null || !(dispatch instanceof DispatchImpl) || this.serviceName == null && this.configuration == null) {
            return null;
        }
        if (!this.jmsConfigured) {
            this.setupJmsConfiguration();
        }
        DispatchImpl di = (DispatchImpl)dispatch;
        Client cl = di.getClient();
        JMSConfigFeature feature = new JMSConfigFeature();
        feature.setJmsConfig(this.jmsConfiguration);
        feature.initialize(cl, cl.getBus());
        return dispatch;
    }

    public <T> Dispatch<T> configureDispatch(Dispatch<T> dispatch, String addressing) {
        String overrideAddress;
        if (this.configuration == null) {
            if (this.serviceName == null) {
                return null;
            }
            this.configuration = CallContext.resolveConfiguration(this.serviceName);
        }
        if ((overrideAddress = this.getProperty("requestURI2010")) != null && (overrideAddress.equals(addressing) || OVERRIDE_BY_URI_CONFIG.equals(addressing))) {
            return dispatch;
        }
        if (this.jmsConfiguration == null || !(dispatch instanceof DispatchImpl) || this.serviceName == null && this.configuration == null) {
            return null;
        }
        if (!this.jmsConfigured) {
            this.setupJmsConfiguration();
        }
        DispatchImpl di = (DispatchImpl)dispatch;
        Client cl = di.getClient();
        JMSConfigFeature feature = new JMSConfigFeature();
        feature.setJmsConfig(this.jmsConfiguration);
        feature.initialize(cl, cl.getBus());
        return dispatch;
    }

    public JaxWsServerFactoryBean configureServerFactory(JaxWsServerFactoryBean serverFactory) {
        if (this.jmsConfiguration == null || serverFactory == null || this.serviceName == null && this.configuration == null) {
            return null;
        }
        if (!this.jmsConfigured) {
            this.setupJmsConfiguration();
        }
        JMSConfigFeature feature = new JMSConfigFeature();
        feature.setJmsConfig(this.jmsConfiguration);
        ArrayList<JMSConfigFeature> features = serverFactory.getFeatures();
        if (features == null) {
            features = new ArrayList<JMSConfigFeature>();
        }
        features.add(feature);
        serverFactory.setFeatures(features);
        return serverFactory;
    }

    public JMSConfiguration setupJmsConfiguration() {
        String password;
        String userName;
        Boolean jmsProviderTibcoEms;
        Boolean enforceSpec;
        String requestURI;
        String targetService;
        String durableSubscriptionClientId;
        Boolean wrapInSingleConnectionFactory;
        Boolean acceptMessagesWhileStopping;
        Boolean reconnectOnException;
        Boolean useConduitIdSelector;
        Integer reconnectPercentOfMax;
        Integer maxSuspendedContinuations;
        Integer maxConcurrentConsumers;
        Integer concurrentConsumers;
        Boolean sessionTransacted;
        Boolean useJms11;
        Boolean replyPubSubDomain;
        Boolean pubSubDomain;
        String messageType;
        String replyToDestination;
        String replyDestination;
        String targetDestination;
        String durableSubscriptionName;
        Boolean subscriptionDurable;
        String conduitSelectorPrefix;
        String messageSelector;
        Long timeToLive;
        Integer priority;
        Integer deliveryMode;
        Boolean explicitQosEnabled;
        Long serverReceiveTimeout;
        Long clientReceiveTimeout;
        Long receiveTimeout;
        Boolean pubSubNoLocal;
        Boolean messageTimestampEnabled;
        Boolean messageIdEnabled;
        Boolean usingEndpointInfo;
        Boolean autoResolveDestination;
        Long recoveryInterval;
        Integer cacheLevel;
        String cacheLevelName;
        if (this.jmsConfiguration == null) {
            return null;
        }
        this.jmsConfigured = true;
        if (this.configuration == null) {
            this.configuration = CallContext.resolveConfiguration(this.serviceName);
        }
        if ((cacheLevelName = this.getProperty("cacheLevelName")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"cacheLevelName\"");
        }
        if ((cacheLevel = this.getIntegerProperty("cacheLevel")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"cacheLevel\"");
        }
        if ((recoveryInterval = this.getLongProperty("recoveryInterval")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"recoveryInterval\"");
        }
        if ((autoResolveDestination = this.getBooleanProperty("autoResolveDestination")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"autoResolveDestination\"");
        }
        if ((usingEndpointInfo = this.getBooleanProperty("usingEndpointInfo")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"usingEndpointInfo\"");
        }
        if ((messageIdEnabled = this.getBooleanProperty("messageIdEnabled")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"messageIdEnabled\"");
        }
        if ((messageTimestampEnabled = this.getBooleanProperty("messageTimestampEnabled")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"messageTimestampEnabled\"");
        }
        if ((pubSubNoLocal = this.getBooleanProperty("pubSubNoLocal")) != null) {
            this.jmsConfiguration.setPubSubNoLocal(pubSubNoLocal.booleanValue());
        }
        if ((receiveTimeout = this.getLongProperty("receiveTimeout")) != null) {
            this.jmsConfiguration.setReceiveTimeout(receiveTimeout);
        }
        if ((clientReceiveTimeout = this.getLongProperty("clientReceiveTimeout")) != null) {
            this.jmsConfiguration.setReceiveTimeout(clientReceiveTimeout);
        }
        if ((serverReceiveTimeout = this.getLongProperty("serverReceiveTimeout")) != null) {
            this.jmsConfiguration.setServerReceiveTimeout(serverReceiveTimeout);
        }
        if ((explicitQosEnabled = this.getBooleanProperty("explicitQosEnabled")) != null) {
            this.jmsConfiguration.setExplicitQosEnabled(explicitQosEnabled.booleanValue());
        }
        if ((deliveryMode = this.getIntegerProperty("deliveryMode")) != null) {
            this.jmsConfiguration.setDeliveryMode(deliveryMode.intValue());
        }
        if ((priority = this.getIntegerProperty("priority")) != null) {
            this.jmsConfiguration.setPriority(priority.intValue());
        }
        if ((timeToLive = this.getLongProperty("timeToLive")) != null) {
            this.jmsConfiguration.setTimeToLive(timeToLive.longValue());
        }
        if ((messageSelector = this.getProperty("messageSelector")) != null) {
            this.jmsConfiguration.setMessageSelector(messageSelector);
        }
        if ((conduitSelectorPrefix = this.getProperty("conduitSelectorPrefix")) != null) {
            this.jmsConfiguration.setConduitSelectorPrefix(conduitSelectorPrefix);
        }
        if ((subscriptionDurable = this.getBooleanProperty("subscriptionDurable")) != null) {
            this.jmsConfiguration.setSubscriptionDurable(subscriptionDurable.booleanValue());
        }
        if ((durableSubscriptionName = this.getProperty("durableSubscriptionName")) != null) {
            this.jmsConfiguration.setDurableSubscriptionName(durableSubscriptionName);
        }
        if ((targetDestination = this.getProperty("targetDestination")) != null) {
            this.jmsConfiguration.setTargetDestination(targetDestination);
        }
        if ((replyDestination = this.getProperty("replyDestination")) != null) {
            this.jmsConfiguration.setReplyDestination(replyDestination);
        }
        if ((replyToDestination = this.getProperty("replyToDestination")) != null) {
            this.jmsConfiguration.setReplyToDestination(replyToDestination);
        }
        if ((messageType = this.getProperty("messageType")) != null) {
            this.jmsConfiguration.setMessageType(messageType);
        }
        if ((pubSubDomain = this.getBooleanProperty("pubSubDomain")) != null) {
            this.jmsConfiguration.setPubSubDomain(pubSubDomain.booleanValue());
        }
        if ((replyPubSubDomain = this.getBooleanProperty("replyPubSubDomain")) != null) {
            this.jmsConfiguration.setReplyPubSubDomain(replyPubSubDomain.booleanValue());
        }
        if ((useJms11 = this.getBooleanProperty("useJms11")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"useJms11\"");
        }
        if ((sessionTransacted = this.getBooleanProperty("sessionTransacted")) != null) {
            this.jmsConfiguration.setSessionTransacted(sessionTransacted.booleanValue());
        }
        if ((concurrentConsumers = this.getIntegerProperty("concurrentConsumers")) != null) {
            this.jmsConfiguration.setConcurrentConsumers(concurrentConsumers.intValue());
        }
        if ((maxConcurrentConsumers = this.getIntegerProperty("maxConcurrentConsumers")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"maxConcurrentConsumers\"");
        }
        if ((maxSuspendedContinuations = this.getIntegerProperty("maxSuspendedContinuations")) != null) {
            this.jmsConfiguration.setMaxSuspendedContinuations(maxSuspendedContinuations.intValue());
        }
        if ((reconnectPercentOfMax = this.getIntegerProperty("reconnectPercentOfMax")) != null) {
            this.jmsConfiguration.setReconnectPercentOfMax(reconnectPercentOfMax.intValue());
        }
        if ((useConduitIdSelector = this.getBooleanProperty("useConduitIdSelector")) != null) {
            this.jmsConfiguration.setUseConduitIdSelector(useConduitIdSelector.booleanValue());
        }
        if ((reconnectOnException = this.getBooleanProperty("reconnectOnException")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"reconnectOnException\"");
        }
        if ((acceptMessagesWhileStopping = this.getBooleanProperty("acceptMessagesWhileStopping")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"acceptMessagesWhileStopping\"");
        }
        if ((wrapInSingleConnectionFactory = this.getBooleanProperty("wrapInSingleConnectionFactory")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"wrapInSingleConnectionFactory\"");
        }
        if ((durableSubscriptionClientId = this.getProperty("durableSubscriptionClientId")) != null) {
            this.jmsConfiguration.setDurableSubscriptionClientId(durableSubscriptionClientId);
        }
        if ((targetService = this.getProperty("targetService")) != null) {
            this.jmsConfiguration.setTargetService(targetService);
        }
        if ((requestURI = this.getProperty("requestURI")) != null) {
            this.jmsConfiguration.setRequestURI(requestURI);
        }
        if ((enforceSpec = this.getBooleanProperty("enforceSpec")) != null) {
            LOGGER.warning("Obsolete JMS configuration property: \"enforceSpec\"");
        }
        if ((jmsProviderTibcoEms = this.getBooleanProperty("jmsProviderTibcoEms")) != null) {
            this.jmsConfiguration.setJmsProviderTibcoEms(jmsProviderTibcoEms.booleanValue());
        }
        this.configureJndi(this.jmsConfiguration);
        String connectionFactoryName = this.getProperty("connectionFactoryName");
        if (connectionFactoryName != null) {
            this.jmsConfiguration.setConnectionFactoryName(connectionFactoryName);
        }
        if ((userName = this.getProperty("userName")) != null) {
            this.jmsConfiguration.setUserName(userName);
        }
        if ((password = this.getProperty("password")) != null) {
            this.jmsConfiguration.setPassword(password);
        }
        return this.jmsConfiguration;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public String getConfigurationPrefix() {
        return this.configurationPrefix;
    }

    public void setConfigurationPrefix(String configurationPrefix) {
        this.configurationPrefix = configurationPrefix;
        this.workPrefix = configurationPrefix == null ? null : configurationPrefix + ".";
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public JMSConfiguration getJmsConfiguration() {
        return this.jmsConfiguration;
    }

    public void setJmsConfiguration(JMSConfiguration jmsConfiguration) {
        this.jmsConfiguration = jmsConfiguration;
    }

    private void configureJndi(JMSConfiguration jmsConfiguration) {
        Properties env;
        boolean hasNoEnv;
        String connectionPassword;
        String connectionUserName;
        Configuration cfg = this.configuration == null ? CallContext.resolveConfiguration(this.serviceName) : this.configuration;
        String jndiConnectionFactoryName = this.getJndiProperty("jndiConnectionFactoryName");
        if (jndiConnectionFactoryName != null) {
            jmsConfiguration.setConnectionFactoryName(jndiConnectionFactoryName);
        }
        if ((connectionUserName = this.getJndiProperty("connectionUserName")) != null) {
            jmsConfiguration.setUserName(connectionUserName);
        }
        if ((connectionPassword = this.getJndiProperty("connectionPassword")) != null) {
            jmsConfiguration.setPassword(connectionPassword);
        }
        boolean bl = hasNoEnv = (env = jmsConfiguration.getJndiEnvironment()) == null;
        if (hasNoEnv) {
            env = new Properties();
        }
        cfg.fillProperties("jndiConfig.environment", env);
        if (this.workPrefix != null) {
            cfg.fillProperties(this.workPrefix + "jndiConfig.environment", env);
        }
        if (hasNoEnv && !env.isEmpty()) {
            jmsConfiguration.setJndiEnvironment(env);
        }
    }

    private String getProperty(String key) {
        String result = null;
        if (this.workPrefix != null) {
            result = this.configuration.getProperty(this.workPrefix + key);
        }
        return result == null ? this.configuration.getProperty(key) : result;
    }

    private String getJndiProperty(String key) {
        String result = null;
        if (this.workPrefix != null) {
            result = this.configuration.getProperty(this.workPrefix + "jndiConfig." + key);
        }
        return result == null ? this.configuration.getProperty("jndiConfig." + key) : result;
    }

    private Boolean getBooleanProperty(String key) {
        Boolean result = null;
        if (this.workPrefix != null) {
            result = this.configuration.getBooleanProperty(this.workPrefix + key);
        }
        return result == null ? this.configuration.getBooleanProperty(key) : result;
    }

    private Integer getIntegerProperty(String key) {
        Integer result = null;
        if (this.workPrefix != null) {
            result = this.configuration.getIntegerProperty(this.workPrefix + key);
        }
        return result == null ? this.configuration.getIntegerProperty(key) : result;
    }

    private Long getLongProperty(String key) {
        Long result = null;
        if (this.workPrefix != null) {
            result = this.configuration.getLongProperty(this.workPrefix + key);
        }
        return result == null ? this.configuration.getLongProperty(key) : result;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jmsConfiguration == null) {
            throw new IllegalStateException("Missing JMS Configuration. ");
        }
        this.setupJmsConfiguration();
        this.jmsConfiguration.afterPropertiesSet();
    }
}

