/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal.zk;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.zookeeper.CreateMode;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.internal.NodePath;
import org.talend.esb.servicelocator.client.internal.RootNode;
import org.talend.esb.servicelocator.client.internal.ServiceNode;
import org.talend.esb.servicelocator.client.internal.zk.ServiceNodeImpl;
import org.talend.esb.servicelocator.client.internal.zk.ZKBackend;

public class RootNodeImpl
extends NodePath
implements RootNode {
    private static final String ROOT_NODE_PATH = "cxf-locator";
    private static final String V_5_1 = "5.1";
    private static final ZKBackend.NodeMapper<QName> TO_SERVICE_NAME = new ZKBackend.NodeMapper<QName>(){

        @Override
        public QName map(String nodeName) {
            return QName.valueOf(nodeName);
        }
    };
    private boolean contentRetrieved;
    private ZKBackend zkBackend;
    private boolean authenticated;
    private String version = "5.1";

    public RootNodeImpl(ZKBackend backend) {
        super(ROOT_NODE_PATH);
        this.zkBackend = backend;
    }

    public boolean exists() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.nodeExists(this);
    }

    public void ensureExists() throws ServiceLocatorException, InterruptedException {
        this.zkBackend.ensurePathExists(this, CreateMode.PERSISTENT);
    }

    @Override
    public ServiceNode getServiceNode(QName serviceName) {
        return new ServiceNodeImpl(this.zkBackend, this, serviceName);
    }

    @Override
    public List<QName> getServiceNames() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.getChildren(this, TO_SERVICE_NAME);
    }

    public boolean isAuthenticationEnabled() throws ServiceLocatorException, InterruptedException {
        this.retrieveContent();
        return this.authenticated;
    }

    public String getVersion() throws ServiceLocatorException, InterruptedException {
        this.retrieveContent();
        return this.version;
    }

    private void retrieveContent() throws ServiceLocatorException, InterruptedException {
        byte[] content;
        String contentStr;
        String[] parts;
        if (!this.contentRetrieved && this.exists() && (parts = (contentStr = new String(content = this.zkBackend.getContent(this), ZKBackend.UTF8_CHAR_SET)).split(",")).length == 2) {
            this.version = parts[0];
            this.authenticated = Boolean.parseBoolean(parts[1]);
        }
        this.contentRetrieved = true;
    }
}

