/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.talend.esb.servicelocator.client.SLEndpoint;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.internal.ServiceLocatorImpl;
import org.talend.esb.servicelocator.client.internal.zk.ZKBackend;

public class ServiceLocatorMain {
    private ServiceLocatorImpl sl;
    private ZKBackend backend = new ZKBackend();
    private PrintStream out;

    public ServiceLocatorMain() {
        this.sl = new ServiceLocatorImpl();
        this.sl.setBackend(this.backend);
    }

    public void setLocatorEndpoints(String locatorEndpoints) {
        this.backend.setLocatorEndpoints(locatorEndpoints);
    }

    public void exec(OutputStream outputStream) throws InterruptedException, ServiceLocatorException {
        this.out = new PrintStream(outputStream);
        this.sl.connect();
        this.printServices();
        this.sl.disconnect();
    }

    private void printServices() throws InterruptedException, ServiceLocatorException {
        List<QName> services = this.sl.getServices();
        boolean first = true;
        for (QName service : services) {
            if (!first) {
                this.out.println(" |");
            }
            this.out.println(service);
            this.printEndpoints(service);
            first = false;
        }
    }

    private void printEndpoints(QName service) throws InterruptedException, ServiceLocatorException {
        List<SLEndpoint> endpoints = this.sl.getEndpoints(service);
        for (SLEndpoint endpoint : endpoints) {
            this.out.println(" |--- " + endpoint.getAddress());
            this.out.println(" |    |-- " + (endpoint.isLive() ? "running" : "stopped"));
            this.out.println(" |    |-- last time started " + this.formatTimeStamp(endpoint.getLastTimeStarted()));
            this.out.println(" |    |-- last time stopped " + this.formatTimeStamp(endpoint.getLastTimeStopped()));
            this.out.println(" |    |-- transport " + endpoint.getTransport());
            this.out.println(" |    |-- protocol " + endpoint.getBinding());
            this.printProperties(endpoint.getProperties());
        }
    }

    private String formatTimeStamp(long timestamp) {
        Object timeStampStr;
        if (timestamp >= 0L) {
            Calendar timeStarted = Calendar.getInstance();
            DateFormat dFormat = DateFormat.getDateInstance();
            DateFormat tFormat = DateFormat.getTimeInstance();
            timeStarted.setTimeInMillis(timestamp);
            timeStampStr = dFormat.format(timeStarted.getTime()) + " " + tFormat.format(timeStarted.getTime());
        } else {
            timeStampStr = "n/a";
        }
        return timeStampStr;
    }

    private void printProperties(SLProperties props) {
        Collection<String> names = props.getPropertyNames();
        if (names.isEmpty()) {
            this.out.println(" |    |-- no properties defined");
        } else {
            for (String name : props.getPropertyNames()) {
                props.getValues(name);
                this.out.println(" |    |-- key: " + name + ", values: " + props.getValues(name));
            }
        }
    }

    public static void main(String[] args) {
        ServiceLocatorMain main = new ServiceLocatorMain();
        if (!ServiceLocatorMain.parseOptions(args, main)) {
            ServiceLocatorMain.usage();
            return;
        }
        try {
            main.exec(System.out);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ServiceLocatorException e) {
            e.printStackTrace();
        }
    }

    private static boolean parseOptions(String[] args, ServiceLocatorMain main) {
        List<String> argList = Arrays.asList(args);
        Iterator<String> argIter = argList.iterator();
        while (argIter.hasNext()) {
            String opt = argIter.next();
            try {
                if ("-endpoints".equals(opt)) {
                    main.setLocatorEndpoints(argIter.next());
                    continue;
                }
                System.err.println("Error: unknown option " + opt);
                return false;
            }
            catch (NoSuchElementException e) {
                System.err.println("Error: no argument found for option " + opt);
                return false;
            }
        }
        return true;
    }

    static void usage() {
        System.err.println("ServiceLocatorMain -endpoints host:port[,host:port]*");
    }
}

