/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal.zk;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.zookeeper.CreateMode;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.internal.EndpointNode;
import org.talend.esb.servicelocator.client.internal.NodePath;
import org.talend.esb.servicelocator.client.internal.ServiceNode;
import org.talend.esb.servicelocator.client.internal.zk.EndpointNodeImpl;
import org.talend.esb.servicelocator.client.internal.zk.RootNodeImpl;
import org.talend.esb.servicelocator.client.internal.zk.ZKBackend;

public class ServiceNodeImpl
extends NodePath
implements ServiceNode {
    private static final ZKBackend.NodeMapper<String> ID_MAPPER = new ZKBackend.NodeMapper<String>(){

        @Override
        public String map(String endpoint) {
            return endpoint;
        }
    };
    private ZKBackend zkBackend;

    public ServiceNodeImpl(ZKBackend backend, RootNodeImpl rootNode, QName serviceName) {
        super(rootNode, serviceName.toString());
        this.zkBackend = backend;
    }

    @Override
    public QName getServiceName() {
        return QName.valueOf(this.getNodeName());
    }

    @Override
    public boolean exists() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.nodeExists(this);
    }

    @Override
    public void ensureExists() throws ServiceLocatorException, InterruptedException {
        this.zkBackend.ensurePathExists(this, CreateMode.PERSISTENT);
    }

    @Override
    public void ensureRemoved() throws ServiceLocatorException, InterruptedException {
        this.zkBackend.ensurePathDeleted(this, true);
    }

    @Override
    public List<String> getEndpointNames() throws ServiceLocatorException, InterruptedException {
        return this.zkBackend.getChildren(this, ID_MAPPER);
    }

    @Override
    public List<EndpointNode> getEndPoints() throws ServiceLocatorException, InterruptedException {
        ZKBackend.NodeMapper<EndpointNode> toEndpointNode = new ZKBackend.NodeMapper<EndpointNode>(){

            @Override
            public EndpointNode map(String endpoint) {
                return new EndpointNodeImpl(ServiceNodeImpl.this.zkBackend, ServiceNodeImpl.this, endpoint);
            }
        };
        return this.zkBackend.getChildren(this, toEndpointNode);
    }

    @Override
    public EndpointNode getEndPoint(String endpoint) {
        return new EndpointNodeImpl(this.zkBackend, this, endpoint);
    }
}

