/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.springframework.beans.factory.annotation.Value;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategy;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategyFactory;
import org.talend.esb.servicelocator.cxf.internal.LocatorSelectionStrategyMap;
import org.talend.esb.servicelocator.cxf.internal.LocatorTargetSelector;

@Named
@Singleton
public class LocatorClientEnabler {
    private static final Logger LOG = Logger.getLogger(LocatorClientEnabler.class.getPackage().getName());
    private static final String DEFAULT_STRATEGY = "defaultSelectionStrategy";
    @Inject
    private ServiceLocator locatorClient;
    @Inject
    private LocatorSelectionStrategyMap locatorSelectionStrategyMap;
    private String defaultLocatorSelectionStrategy;

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.locatorClient = serviceLocator;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client " + serviceLocator + " was set for LocatorClientRegistrar.");
        }
    }

    public void setLocatorSelectionStrategyMap(LocatorSelectionStrategyMap locatorSelectionStrategyMap) {
        this.locatorSelectionStrategyMap = locatorSelectionStrategyMap;
    }

    private LocatorSelectionStrategy getLocatorSelectionStrategy(String locatorSelectionStrategy) {
        if (null == locatorSelectionStrategy) {
            return ((LocatorSelectionStrategyFactory)this.locatorSelectionStrategyMap.get(DEFAULT_STRATEGY)).getInstance();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Strategy " + locatorSelectionStrategy + " was set for LocatorClientRegistrar.");
        }
        if (this.locatorSelectionStrategyMap.containsKey(locatorSelectionStrategy)) {
            return ((LocatorSelectionStrategyFactory)this.locatorSelectionStrategyMap.get(locatorSelectionStrategy)).getInstance();
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "LocatorSelectionStrategy " + locatorSelectionStrategy + " not registered at LocatorClientEnabler.");
        }
        return ((LocatorSelectionStrategyFactory)this.locatorSelectionStrategyMap.get(DEFAULT_STRATEGY)).getInstance();
    }

    @Value(value="${locator.strategy}")
    public void setDefaultLocatorSelectionStrategy(String defaultLocatorSelectionStrategy) {
        this.defaultLocatorSelectionStrategy = defaultLocatorSelectionStrategy;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Default strategy " + defaultLocatorSelectionStrategy + " was set for LocatorClientRegistrar.");
        }
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder) {
        this.enable(conduitSelectorHolder, null);
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder, SLPropertiesMatcher matcher) {
        this.enable(conduitSelectorHolder, matcher, null);
    }

    public void enable(ConduitSelectorHolder conduitSelectorHolder, SLPropertiesMatcher matcher, String selectionStrategy) {
        LocatorTargetSelector selector = new LocatorTargetSelector();
        selector.setEndpoint(conduitSelectorHolder.getConduitSelector().getEndpoint());
        String actualStrategy = selectionStrategy != null ? selectionStrategy : this.defaultLocatorSelectionStrategy;
        LocatorSelectionStrategy locatorSelectionStrategy = this.getLocatorSelectionStrategy(actualStrategy);
        locatorSelectionStrategy.setServiceLocator(this.locatorClient);
        if (matcher != null) {
            locatorSelectionStrategy.setMatcher(matcher);
        }
        selector.setLocatorSelectionStrategy(locatorSelectionStrategy);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "Client enabled with strategy " + locatorSelectionStrategy.getClass().getName() + ".");
        }
        conduitSelectorHolder.setConduitSelector((ConduitSelector)selector);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Successfully enabled client " + conduitSelectorHolder + " for the service locator");
        }
    }
}

