/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.ConduitSelectorHolder;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.SLPropertiesImpl;
import org.talend.esb.servicelocator.client.SLPropertiesMatcher;
import org.talend.esb.servicelocator.cxf.LocatorFeature;
import org.talend.esb.servicelocator.cxf.internal.LocatorClientEnabler;
import org.talend.esb.servicelocator.cxf.internal.LocatorRegistrar;

@OsgiServiceProvider(classes={LocatorFeature.class})
@Named(value="locatorFeature")
@Singleton
public class LocatorFeatureImpl
extends AbstractFeature
implements LocatorFeature {
    private static final Logger LOG = Logger.getLogger(LocatorFeatureImpl.class.getName());
    @Inject
    LocatorRegistrar locatorRegistrar;
    @Inject
    LocatorClientEnabler clientEnabler;

    public void initialize(Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing Locator feature for bus " + bus);
        }
        this.locatorRegistrar.startListenForServers(bus);
        ClientLifeCycleManager clcm = (ClientLifeCycleManager)bus.getExtension(ClientLifeCycleManager.class);
        clcm.registerListener((ClientLifeCycleListener)new ClientLifeCycleListenerForLocator());
    }

    public void initialize(Client client, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and client " + client);
        }
        String selectionStrategy = (String)client.getEndpoint().get((Object)"locator.strategy");
        Map<String, String> endpointProps = this.getEndpointLocatorProperties(client.getEndpoint());
        Client client1 = client;
        this.clientEnabler.enable((ConduitSelectorHolder)client1, this.createMatcher(endpointProps), selectionStrategy);
    }

    public void initialize(Server server, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and server " + server);
        }
        Map<String, String> endpointProps = this.getEndpointLocatorProperties(server.getEndpoint());
        this.locatorRegistrar.registerServer(server, this.createProperties(endpointProps), bus);
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        if (interceptorProvider instanceof ConduitSelectorHolder) {
            this.initialize((ConduitSelectorHolder)interceptorProvider, bus);
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Tried to initialize locator feature with unknown interceptor provider " + interceptorProvider);
        }
    }

    public void initialize(ConduitSelectorHolder conduitSelectorHolder, Bus bus) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initializing locator feature for bus " + bus + " and client configuration" + conduitSelectorHolder);
        }
        ConduitSelector conduitSelector = conduitSelectorHolder.getConduitSelector();
        String selectionStrategy = (String)conduitSelector.getEndpoint().get((Object)"locator.strategy");
        Map<String, String> endpointProps = this.getEndpointLocatorProperties(conduitSelector.getEndpoint());
        SLPropertiesMatcher slPropsMatcher = this.createMatcher(endpointProps);
        ConduitSelectorHolder conduitSelectorHolder1 = conduitSelectorHolder;
        this.clientEnabler.enable(conduitSelectorHolder1, slPropsMatcher, selectionStrategy);
    }

    private SLPropertiesMatcher createMatcher(Map<String, String> properties) {
        SLPropertiesMatcher slPropsMatcher = new SLPropertiesMatcher();
        if (properties == null) {
            return slPropsMatcher;
        }
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            for (String prop : properties.keySet()) {
                sb.append(prop + " -> ");
                sb.append(properties.get(prop) + "\n");
            }
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            for (String value : this.tokenize(entry.getValue())) {
                slPropsMatcher.addAssertion(entry.getKey(), value);
            }
        }
        LOG.fine("set matcher = " + slPropsMatcher.toString());
        for (StackTraceElement trace : new Throwable().getStackTrace()) {
            LOG.fine(trace.toString());
        }
        return slPropsMatcher;
    }

    private SLProperties createProperties(Map<String, String> properties) {
        SLPropertiesImpl slProps = new SLPropertiesImpl();
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                slProps.addProperty(entry.getKey(), this.tokenize(entry.getValue()));
            }
        }
        return slProps;
    }

    Collection<String> tokenize(String valueList) {
        return Arrays.asList(valueList.split(","));
    }

    private Map<String, String> getEndpointLocatorProperties(Endpoint endpoint) {
        return (Map)endpoint.get((Object)"esb.locator.properties");
    }

    public void setLocatorRegistrar(LocatorRegistrar locatorRegistrar) {
        this.locatorRegistrar = locatorRegistrar;
    }

    public void setClientEnabler(LocatorClientEnabler clientEnabler) {
        this.clientEnabler = clientEnabler;
    }

    class ClientLifeCycleListenerForLocator
    implements ClientLifeCycleListener {
        ClientLifeCycleListenerForLocator() {
        }

        public void clientCreated(Client client) {
            LocatorFeatureImpl.this.clientEnabler.enable((ConduitSelectorHolder)client, null, null);
        }

        public void clientDestroyed(Client client) {
        }
    }
}

