/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.client.internal.zk;

import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

public class LocatorSettings {
    public static final Charset UTF8_CHAR_SET = Charset.forName("UTF-8");
    public static final String USER_PROP = "user";
    public static final String PWD_PROP = "password";
    private static final Logger LOG = Logger.getLogger(LocatorSettings.class.getName());
    private int sesTimeout = 5000;
    private int conTimeout = 5000;
    private String locatorEndpoints;
    private String userInEndpoint;
    private String pwdInEndpoint;
    private String userExplicit;
    private String pwdExplicit;

    public String getEndpoints() {
        return this.locatorEndpoints;
    }

    public void setEndpoints(String endpoints) {
        String[] parts = endpoints.split(";");
        this.locatorEndpoints = parts[0].trim();
        if (parts.length >= 2) {
            this.parseCredentials(parts[1]);
        }
        if (parts.length >= 3) {
            this.parseCredentials(parts[2]);
        }
    }

    public void setUser(String user) {
        String string = this.userExplicit = "".equals(user) ? null : user;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("User for authentication to Service Locator set to: " + this.userExplicit);
        }
    }

    public String getUser() {
        return this.userExplicit != null ? this.userExplicit : this.userInEndpoint;
    }

    public void setPassword(String password) {
        String string = this.pwdExplicit = "".equals(password) ? null : password;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Password for authentication to Service Locator set.");
        }
    }

    public String getPassword() {
        return this.pwdExplicit != null ? this.pwdExplicit : this.pwdInEndpoint;
    }

    public int getSessionTimeout() {
        return this.sesTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sesTimeout = sessionTimeout;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator session timeout set to: " + this.sesTimeout);
        }
    }

    public int getConnectionTimeout() {
        return this.conTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.conTimeout = connectionTimeout;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Locator connection timeout set to: " + this.conTimeout);
        }
    }

    private void parseCredentials(String credential) {
        String[] credentialParts = credential.split("=");
        if (credentialParts.length != 2) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Unable to interprete credential parameter '" + credential + "', when parsing the endpoints property.");
            }
            return;
        }
        String property = credentialParts[0].trim();
        if (property.equals(USER_PROP)) {
            this.userInEndpoint = credentialParts[1].trim();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("User for authentication to Service Locator set to: " + this.userExplicit + " via endpoints parameter");
            }
        } else if (property.equals(PWD_PROP)) {
            this.pwdInEndpoint = credentialParts[1].trim();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Password for authentication to Service Locator set via endpoints parameter");
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "Property " + property + " is not a valid credential property.");
        }
    }

    public byte[] getAuthInfo() throws ServiceLocatorException {
        if (this.getUser() == null) {
            throw new ServiceLocatorException("Service Locator server requires authorization, but no user is defined.");
        }
        if (this.getPassword() == null) {
            throw new ServiceLocatorException("Service Locator server requires authorization, but no password is defined.");
        }
        return (this.getUser() + ":" + this.getPassword()).getBytes(UTF8_CHAR_SET);
    }
}

