/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.servicelocator.cxf.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.HttpsToken;
import org.apache.wss4j.policy.model.TransportBinding;
import org.apache.wss4j.policy.model.TransportToken;
import org.talend.esb.servicelocator.client.SLProperties;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;
import org.talend.esb.servicelocator.client.TransportType;
import org.talend.esb.servicelocator.cxf.internal.CXFEndpointProvider;

public class SingleBusLocatorRegistrar
implements ServerLifeCycleListener,
ServiceLocator.PostConnectAction {
    private static final Logger LOG = Logger.getLogger(SingleBusLocatorRegistrar.class.getPackage().getName());
    private Bus bus;
    private ServiceLocator locatorClient;
    private String endpointPrefix = "";
    private Map<String, String> endpointPrefixes = null;
    private Map<Server, CXFEndpointProvider> registeredServers = Collections.synchronizedMap(new LinkedHashMap());
    private boolean listenForServersEnabled;

    public SingleBusLocatorRegistrar(Bus bus) {
        this.bus = bus;
        this.registerListener();
    }

    public void startServer(Server server) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Server " + server + " starting...");
        }
        if (this.listenForServersEnabled) {
            this.registerServer(server);
        }
    }

    public void stopServer(Server server) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Server " + server + " stopping...");
        }
        if (this.registeredServers.containsKey(server)) {
            this.unregisterServer(server);
        }
    }

    public void startListenForServers() {
        this.check(this.bus, "bus", "startListenForServers");
        this.listenForServersEnabled = true;
        this.registerAvailableServers();
    }

    public void stopListenForServers() {
        this.listenForServersEnabled = false;
    }

    @Override
    public void process(ServiceLocator lc) {
        for (Server server : this.registeredServers.keySet()) {
            this.registerServer(this.registeredServers.get(server));
        }
    }

    public void setEndpointPrefix(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix != null ? endpointPrefix : "";
    }

    public void setEndpointPrefixes(Map<String, String> endpointPrefixes) {
        this.endpointPrefixes = endpointPrefixes;
    }

    public void setServiceLocator(ServiceLocator serviceLocator) {
        this.locatorClient = serviceLocator;
        serviceLocator.setPostConnectAction(this);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Locator client was set.");
        }
    }

    private void registerListener() {
        ServerLifeCycleManager manager = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
        if (manager != null) {
            manager.registerListener((ServerLifeCycleListener)this);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Server life cycle listener registered.");
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, "ServerLifeCycleManager is not available.");
        }
    }

    public void registerServer(Server server) {
        this.registerServer(server, null);
    }

    public void registerServer(Server server, SLProperties props) {
        this.check(this.locatorClient, "serviceLocator", "registerEndpoint");
        String address = this.getAddress(server);
        if (this.isRelativeAddress(address)) {
            String prefix = null;
            if (this.endpointPrefixes == null || this.endpointPrefixes.size() == 0) {
                prefix = this.endpointPrefix;
            } else {
                if (this.isSecuredByProperty(server) || this.isSecuredByPolicy(server)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Endpoint " + server.getEndpoint().getEndpointInfo().getService().toString() + " is secured");
                    }
                    prefix = this.endpointPrefixes.get(TransportType.HTTPS.toString());
                } else {
                    prefix = this.endpointPrefixes.get(TransportType.HTTP.toString());
                }
                if (prefix == null || prefix.equals("")) {
                    LOG.warning("endpointPrefixes defined but empty. Using default");
                    prefix = this.endpointPrefix;
                }
            }
            address = prefix + address;
        }
        CXFEndpointProvider endpoint = new CXFEndpointProvider(server, address, props);
        this.registerServer(endpoint);
        this.registeredServers.put(server, endpoint);
    }

    private void registerServer(CXFEndpointProvider endpointProvider) {
        block4: {
            try {
                this.locatorClient.register(endpointProvider);
            }
            catch (ServiceLocatorException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "ServiceLocator Exception thrown when registering for endpoint " + endpointProvider, e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "Interrupted Exception thrown when registering  for endpoint " + endpointProvider, e);
            }
        }
    }

    private void unregisterServer(Server server) {
        block4: {
            try {
                CXFEndpointProvider epp = this.registeredServers.get(server);
                this.locatorClient.unregister(epp);
            }
            catch (ServiceLocatorException e) {
                if (LOG.isLoggable(Level.SEVERE)) {
                    LOG.log(Level.SEVERE, "ServiceLocator Exception thrown during unregister endpoint. ", e);
                }
            }
            catch (InterruptedException e) {
                if (!LOG.isLoggable(Level.SEVERE)) break block4;
                LOG.log(Level.SEVERE, "Interrupted Exception thrown during unregister endpoint.", e);
            }
        }
    }

    private void registerAvailableServers() {
        ServerRegistry serverRegistry = (ServerRegistry)this.bus.getExtension(ServerRegistry.class);
        List servers = serverRegistry.getServers();
        for (Server server : servers) {
            this.registerServer(server);
        }
    }

    private String getAddress(Server server) {
        return server.getEndpoint().getEndpointInfo().getAddress();
    }

    private boolean isRelativeAddress(String address) {
        return !address.startsWith("http://") && !address.startsWith("https://");
    }

    private boolean isSecuredByPolicy(Server server) {
        boolean isSecured = false;
        EndpointInfo ei = server.getEndpoint().getEndpointInfo();
        PolicyEngine pe = (PolicyEngine)this.bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            LOG.finest("No Policy engine found");
            return isSecured;
        }
        Destination destination = server.getDestination();
        EndpointPolicy ep = pe.getServerEndpointPolicy(ei, destination, null);
        Collection assertions = ep.getChosenAlternative();
        for (Assertion a : assertions) {
            TransportBinding tb;
            TransportToken tt;
            AbstractToken t;
            if (!(a instanceof TransportBinding) || !((t = (tt = (tb = (TransportBinding)a).getTransportToken()).getToken()) instanceof HttpsToken)) continue;
            isSecured = true;
            break;
        }
        Policy policy = ep.getPolicy();
        List pcList = policy.getPolicyComponents();
        for (PolicyComponent a : pcList) {
            TransportBinding tb;
            TransportToken tt;
            AbstractToken t;
            if (!(a instanceof TransportBinding) || !((t = (tt = (tb = (TransportBinding)a).getTransportToken()).getToken()) instanceof HttpsToken)) continue;
            isSecured = true;
            break;
        }
        return isSecured;
    }

    private boolean isSecuredByProperty(Server server) {
        boolean isSecured = false;
        Object value = server.getEndpoint().get((Object)"org.talend.tesb.endpoint.secured");
        if (value instanceof String) {
            try {
                isSecured = Boolean.valueOf((String)value);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return isSecured;
    }

    private void check(Object obj, String propertyName, String methodName) {
        if (obj == null) {
            throw new IllegalStateException("The property " + propertyName + " must be set before " + methodName + " can be called.");
        }
    }
}

