/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator.commands;

import javax.xml.namespace.QName;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.talend.esb.locator.completer.EndpointAddressCompleter;
import org.talend.esb.locator.completer.ServiceNameCompleter;
import org.talend.esb.locator.tracker.ServiceLocatorTracker;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

@Command(scope="tlocator", name="unregister", description="Notifies Service Locator that a service endpoint is offline\n\n\u001b[1;37mEXAMPLE\u001b[0m\n\ttlocator:unregister \"{http://my.company.com/my-service-namespace}MyServiceName\" http://my.server.com:8040/services/MyServiceName\n\ttlocator:unregister MyServiceName http://another.server.com:8040/services/MyServiceName")
@Service
public class UnregisterOperation
implements Action {
    @Argument(index=0, name="serviceName", description="Service name for endpoint to be updated.\nIf Service name is unique at Service Locator it is sufficient to only type local part of service name.", required=true, multiValued=false)
    @Completion(value=ServiceNameCompleter.class)
    String service;
    @Argument(index=1, name="URL", description="Endpoint address to be unregistered from Service Locator. This endpoint will be marked as offline.", required=true, multiValued=false)
    @Completion(value=EndpointAddressCompleter.class)
    String endpoint;
    @Reference
    private ServiceLocator sl;

    public Object execute() throws Exception {
        ServiceLocatorTracker slt = ServiceLocatorTracker.getInstance(this.sl);
        System.out.println();
        try {
            QName serviceName = slt.getServiceName(this.service);
            this.sl.unregister(serviceName, this.endpoint);
            System.out.println("Endpoint has been unregistered at Service Locator");
        }
        catch (ServiceLocatorException e) {
            System.err.println(e.getMessage());
        }
        System.out.println();
        return null;
    }
}

