/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.locator.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.esb.servicelocator.client.ServiceLocator;
import org.talend.esb.servicelocator.client.ServiceLocatorException;

public final class ServiceLocatorTracker {
    static final int INTERVAL = 30;
    private static final Logger LOG = LoggerFactory.getLogger(ServiceLocatorTracker.class);
    private static ServiceLocatorTracker serviceLocatorTracker;
    Map<String, List<String>> endpointMap = new HashMap<String, List<String>>();
    Map<String, QName> serviceMap = new HashMap<String, QName>();
    ServiceLocator sl;

    private ServiceLocatorTracker(ServiceLocator serviceLocator) {
        this.sl = serviceLocator;
        this.startMonitoringServiceList();
    }

    public static synchronized ServiceLocatorTracker getInstance(ServiceLocator serviceLocator) {
        if (serviceLocatorTracker == null) {
            serviceLocatorTracker = new ServiceLocatorTracker(serviceLocator);
        }
        return serviceLocatorTracker;
    }

    private void startMonitoringServiceList() {
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ServiceLocatorTracker.this.updateServiceList();
            }
        }, 2L, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceList() {
        try {
            List services = this.sl.getServices();
            ServiceLocatorTracker serviceLocatorTracker = this;
            synchronized (serviceLocatorTracker) {
                this.serviceMap.clear();
                this.endpointMap.clear();
                for (QName service : services) {
                    this.serviceMap.put(service.getLocalPart(), service);
                    this.endpointMap.put(service.toString(), this.sl.getEndpointNames(service));
                }
            }
        }
        catch (InterruptedException services) {
        }
        catch (ServiceLocatorException e) {
            LOG.warn(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getEndpoints(String serviceName) {
        ArrayList<String> result = new ArrayList<String>();
        if (serviceName == null || serviceName.length() == 0) {
            return result;
        }
        serviceName = serviceName.replaceAll("\"", "");
        ServiceLocatorTracker serviceLocatorTracker = this;
        synchronized (serviceLocatorTracker) {
            List<String> endpoints;
            QName service = this.serviceMap.get(serviceName);
            List<String> list = endpoints = service != null ? this.endpointMap.get(service.toString()) : this.endpointMap.get(serviceName);
            if (endpoints != null) {
                result.addAll(endpoints);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getServiceNames(boolean includeNamespace) {
        ServiceLocatorTracker serviceLocatorTracker = this;
        synchronized (serviceLocatorTracker) {
            if (includeNamespace) {
                return this.endpointMap.keySet();
            }
            return this.serviceMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> getServiceQNames() {
        ServiceLocatorTracker serviceLocatorTracker = this;
        synchronized (serviceLocatorTracker) {
            return this.serviceMap.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName getServiceName(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        ServiceLocatorTracker serviceLocatorTracker = this;
        synchronized (serviceLocatorTracker) {
            QName result = this.serviceMap.get(serviceName);
            if (result != null) {
                return result;
            }
            return QName.valueOf(serviceName);
        }
    }
}

