/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.logging.event.layout;

import ch.qos.logback.classic.pattern.RootCauseFirstThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minidev.json.JSONObject;
import org.talend.daikon.logging.event.field.HostData;
import org.talend.daikon.logging.event.field.LayoutFields;
import org.talend.daikon.logging.event.layout.JsonLayout;
import org.talend.daikon.logging.event.layout.LayoutUtils;

public class LogbackJSONLayout
extends JsonLayout<ILoggingEvent> {
    private boolean locationInfo;
    private boolean hostInfo;
    private String customUserFields;
    private Map<String, String> metaFields = new HashMap<String, String>();
    private boolean addEventUuid = true;

    public LogbackJSONLayout() {
        this(false, true);
    }

    public LogbackJSONLayout(boolean locationInfo, boolean hostInfo) {
        this.locationInfo = locationInfo;
        this.hostInfo = hostInfo;
    }

    public String doLayout(ILoggingEvent loggingEvent) {
        JSONObject logstashEvent = new JSONObject();
        JSONObject userFieldsEvent = new JSONObject();
        HostData host = new HostData();
        if (this.getUserFields() != null) {
            String userFlds = this.getUserFields();
            LayoutUtils.addUserFields(userFlds, userFieldsEvent);
        }
        Map<String, String> mdc = LayoutUtils.processMDCMetaFields(loggingEvent.getMDCPropertyMap(), logstashEvent, this.metaFields);
        if (this.addEventUuid) {
            logstashEvent.put((Object)"eventUUID", (Object)UUID.randomUUID().toString());
        }
        logstashEvent.put((Object)"@version", (Object)LayoutFields.VERSION_VALUE);
        logstashEvent.put((Object)"logTimestamp", (Object)this.dateFormat(loggingEvent.getTimeStamp()));
        logstashEvent.put((Object)"severity", (Object)loggingEvent.getLevel().toString());
        logstashEvent.put((Object)"threadName", (Object)loggingEvent.getThreadName());
        logstashEvent.put((Object)"agentTimestamp", (Object)this.dateFormat(new Date().getTime()));
        if (loggingEvent.getFormattedMessage() != null) {
            logstashEvent.put((Object)"logMessage", (Object)loggingEvent.getFormattedMessage());
        }
        this.handleThrown(logstashEvent, loggingEvent);
        JSONObject logSourceEvent = this.createLogSourceEvent(loggingEvent, host);
        logstashEvent.put((Object)"logSource", (Object)logSourceEvent);
        LayoutUtils.addMDC(mdc, userFieldsEvent, logstashEvent);
        if (!userFieldsEvent.isEmpty()) {
            logstashEvent.put((Object)"customInfo", (Object)userFieldsEvent);
        }
        return logstashEvent.toString() + "\n";
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean setHostInfo() {
        return this.hostInfo;
    }

    public void setHostInfo(boolean hostInfo) {
        this.hostInfo = hostInfo;
    }

    public String getUserFields() {
        return this.customUserFields;
    }

    public void setUserFields(String userFields) {
        this.customUserFields = userFields;
    }

    public void setMetaFields(Map<String, String> metaFields) {
        this.metaFields = new HashMap<String, String>(metaFields);
    }

    public void setAddEventUuid(boolean addEventUuid) {
        this.addEventUuid = addEventUuid;
    }

    private void handleThrown(JSONObject logstashEvent, ILoggingEvent loggingEvent) {
        if (loggingEvent.getThrowableProxy() != null) {
            if (loggingEvent.getThrowableProxy().getClassName() != null) {
                logstashEvent.put((Object)"exceptionClass", (Object)loggingEvent.getThrowableProxy().getClassName());
            }
            if (loggingEvent.getThrowableProxy().getMessage() != null) {
                logstashEvent.put((Object)"exceptionMessage", (Object)loggingEvent.getThrowableProxy().getMessage());
            }
            RootCauseFirstThrowableProxyConverter converter = new RootCauseFirstThrowableProxyConverter();
            converter.setOptionList(Collections.singletonList("full"));
            converter.start();
            String stackTrace = converter.convert(loggingEvent);
            logstashEvent.put((Object)"stackTrace", (Object)stackTrace);
        }
    }

    private JSONObject createLogSourceEvent(ILoggingEvent loggingEvent, HostData host) {
        JSONObject logSourceEvent = new JSONObject();
        if (this.locationInfo) {
            StackTraceElement callerData = this.extractCallerData(loggingEvent);
            if (callerData != null) {
                logSourceEvent.put((Object)"file.name", (Object)callerData.getFileName());
                logSourceEvent.put((Object)"line.number", (Object)callerData.getLineNumber());
                logSourceEvent.put((Object)"class.name", (Object)callerData.getClassName());
                logSourceEvent.put((Object)"method.name", (Object)callerData.getMethodName());
            }
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            String jvmName = runtimeBean.getName();
            logSourceEvent.put((Object)"process.id", (Object)Long.valueOf(jvmName.split("@")[0]));
        }
        logSourceEvent.put((Object)"logger.name", (Object)loggingEvent.getLoggerName());
        if (this.hostInfo) {
            logSourceEvent.put((Object)"host.name", (Object)host.getHostName());
            logSourceEvent.put((Object)"host.address", (Object)host.getHostAddress());
        }
        return logSourceEvent;
    }

    private StackTraceElement extractCallerData(ILoggingEvent event) {
        StackTraceElement[] ste = event.getCallerData();
        if (ste == null || ste.length == 0) {
            return null;
        }
        return ste[0];
    }

    private String dateFormat(long timestamp) {
        return LayoutFields.DATETIME_TIME_FORMAT.format(timestamp);
    }
}

