/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.logging.event.layout;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.talend.daikon.logging.event.field.HostData;
import org.talend.daikon.logging.event.field.LayoutFields;
import org.talend.daikon.logging.event.layout.LayoutUtils;

@Plugin(name="Log4j2JSONLayout", category="Core", elementType="layout", printObject=true)
public class Log4j2JSONLayout
extends AbstractStringLayout {
    private static final Map<String, String> ADDITIONAL_ATTRIBUTES = new HashMap<String, String>();
    private boolean locationInfo;
    private boolean hostInfo;
    private String customUserFields;
    private Map<String, String> metaFields = new HashMap<String, String>();

    protected Log4j2JSONLayout(Boolean locationInfo, Boolean hostInfo, Charset charset, Map<String, String> additionalLogAttributes) {
        super(charset);
        this.setLocationInfo(locationInfo);
        this.setHostInfo(hostInfo);
        ADDITIONAL_ATTRIBUTES.putAll(additionalLogAttributes);
    }

    @PluginFactory
    public static AbstractStringLayout createLayout(@PluginAttribute(value="locationInfo") boolean locationInfo, @PluginAttribute(value="hostInfo", defaultBoolean=true) boolean hostInfo, @PluginAttribute(value="properties") boolean properties, @PluginAttribute(value="complete") boolean complete, @PluginAttribute(value="compact") boolean compact, @PluginAttribute(value="eventEol") boolean eventEol, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginElement(value="Pairs") KeyValuePair[] pairs) {
        Map<String, String> additionalLogAttributes = Log4j2JSONLayout.unpackPairs(pairs);
        return new Log4j2JSONLayout(locationInfo, hostInfo, charset, additionalLogAttributes);
    }

    public String toSerializable(LogEvent loggingEvent) {
        JSONObject logstashEvent = new JSONObject();
        JSONObject userFieldsEvent = new JSONObject();
        HostData host = new HostData();
        LayoutUtils.addUserFields(ADDITIONAL_ATTRIBUTES, userFieldsEvent);
        Map<String, String> mdc = LayoutUtils.processMDCMetaFields(loggingEvent.getContextData().toMap(), logstashEvent, this.metaFields);
        logstashEvent.put((Object)"@version", (Object)LayoutFields.VERSION_VALUE);
        logstashEvent.put((Object)"logTimestamp", (Object)LayoutUtils.dateFormat(loggingEvent.getTimeMillis()));
        logstashEvent.put((Object)"severity", (Object)loggingEvent.getLevel().toString());
        logstashEvent.put((Object)"threadName", (Object)loggingEvent.getThreadName());
        logstashEvent.put((Object)"agentTimestamp", (Object)LayoutUtils.dateFormat(new Date().getTime()));
        String formattedMessage = loggingEvent.getMessage().getFormattedMessage();
        if (formattedMessage != null) {
            logstashEvent.put((Object)"logMessage", (Object)formattedMessage);
        }
        this.handleThrown(logstashEvent, loggingEvent);
        JSONObject logSourceEvent = this.createLogSourceEvent(loggingEvent, host);
        logstashEvent.put((Object)"logSource", (Object)logSourceEvent);
        LayoutUtils.addMDC(mdc, userFieldsEvent, logstashEvent);
        if (!userFieldsEvent.isEmpty()) {
            logstashEvent.put((Object)"customInfo", (Object)userFieldsEvent);
        }
        return logstashEvent.toString() + "\n";
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(boolean locationInfo) {
        this.locationInfo = locationInfo;
    }

    public boolean getHostInfo() {
        return this.hostInfo;
    }

    public void setHostInfo(boolean hostInfo) {
        this.hostInfo = hostInfo;
    }

    public String getUserFields() {
        return this.customUserFields;
    }

    public void setUserFields(String userFields) {
        this.customUserFields = userFields;
    }

    private static Map<String, String> unpackPairs(KeyValuePair[] pairs) {
        HashMap<String, String> additionalLogAttributes = new HashMap<String, String>();
        if (pairs != null && pairs.length > 0) {
            for (KeyValuePair pair : pairs) {
                String value;
                String key = pair.getKey();
                if (key == null) {
                    LOGGER.error("A null key is not valid in MapFilter");
                }
                if ((value = pair.getValue()) == null) {
                    LOGGER.error("A null value for key " + key + " is not allowed in MapFilter");
                }
                if (additionalLogAttributes.containsKey(key)) {
                    LOGGER.error("Duplicate entry for key: {} is forbidden!", (Object)key);
                }
                additionalLogAttributes.put(key, value);
            }
        }
        return additionalLogAttributes;
    }

    private JSONObject createLogSourceEvent(LogEvent loggingEvent, HostData host) {
        JSONObject logSourceEvent = new JSONObject();
        if (this.locationInfo && loggingEvent.getSource() != null) {
            logSourceEvent.put((Object)"file.name", (Object)loggingEvent.getSource().getFileName());
            logSourceEvent.put((Object)"line.number", (Object)loggingEvent.getSource().getLineNumber());
            logSourceEvent.put((Object)"class.name", (Object)loggingEvent.getSource().getClassName());
            logSourceEvent.put((Object)"method.name", (Object)loggingEvent.getSource().getMethodName());
            RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
            String jvmName = runtimeBean.getName();
            logSourceEvent.put((Object)"process.id", (Object)Long.valueOf(jvmName.split("@")[0]));
        }
        logSourceEvent.put((Object)"logger.name", (Object)loggingEvent.getLoggerName());
        if (this.hostInfo) {
            logSourceEvent.put((Object)"host.name", (Object)host.getHostName());
            logSourceEvent.put((Object)"host.address", (Object)host.getHostAddress());
        }
        return logSourceEvent;
    }

    private void handleThrown(JSONObject logstashEvent, LogEvent loggingEvent) {
        if (loggingEvent.getThrown() != null) {
            if (loggingEvent.getThrown().getClass() != null && loggingEvent.getThrown().getClass().getCanonicalName() != null) {
                logstashEvent.put((Object)"exceptionClass", (Object)loggingEvent.getThrown().getClass().getCanonicalName());
            }
            if (loggingEvent.getThrown().getMessage() != null) {
                logstashEvent.put((Object)"exceptionMessage", (Object)loggingEvent.getThrown().getMessage());
            }
            this.createStackTraceEvent(logstashEvent, loggingEvent);
        }
    }

    private void createStackTraceEvent(JSONObject logstashEvent, LogEvent loggingEvent) {
        if (loggingEvent.getThrown().getStackTrace() != null) {
            String[] options = new String[]{"full"};
            ThrowablePatternConverter converter = ThrowablePatternConverter.newInstance((String[])options);
            StringBuilder sb = new StringBuilder();
            converter.format(loggingEvent, sb);
            String stackTrace = sb.toString();
            logstashEvent.put((Object)"stackTrace", (Object)stackTrace);
        }
    }
}

