/*
 * Decompiled with CFR 0.152.
 */
package org.talend.cxf.crypto.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.cm.Configuration;

public class CryptoPropertiesFactory {
    private static final Logger LOG = Logger.getLogger(CryptoPropertiesFactory.class.getName());
    private Map<String, Object> defaultProperties;
    private Map<String, Object> updatedProperties;
    private Configuration updatedPropertiesConfiguration;
    private String propertiesSource;

    public Map<String, Object> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public Map<String, Object> getUpdatedProperties() {
        return this.updatedProperties;
    }

    public void setUpdatedProperties(Map<String, Object> updatedProperties) {
        this.updatedProperties = updatedProperties;
    }

    public Configuration getUpdatedPropertiesConfiguration() {
        return this.updatedPropertiesConfiguration;
    }

    public void setUpdatedPropertiesConfiguration(Configuration updatedPropertiesConfiguration) {
        this.updatedPropertiesConfiguration = updatedPropertiesConfiguration;
    }

    public String getPropertiesSource() {
        return this.propertiesSource;
    }

    public void setPropertiesSource(String propertiesSource) {
        this.propertiesSource = propertiesSource;
    }

    public Properties createProperties() {
        Properties result = new Properties();
        if (this.defaultProperties != null) {
            LOG.fine("Adding default properties");
            result.putAll(this.defaultProperties);
        }
        this.loadURLProperties(result);
        this.updateFromConfiguration(result);
        if (this.updatedProperties != null) {
            LOG.fine("Adding updated properties");
            result.putAll(this.updatedProperties);
        }
        return result;
    }

    private void loadURLProperties(Properties props) {
        if (this.propertiesSource == null || this.propertiesSource.isEmpty()) {
            return;
        }
        try {
            LOG.fine("Loading external properties");
            URL propsUrl = new URL(this.propertiesSource);
            try (InputStream is = propsUrl.openStream();){
                props.load(is);
            }
        }
        catch (MalformedURLException e) {
            LOG.info("Properties source is not an URL, assuming file name");
            LOG.log(Level.FINE, "MalformedURLException caught. ", e);
            Object propsFileName = this.propertiesSource;
            if (((String)propsFileName).indexOf(47) < 0 && ((String)propsFileName).indexOf(92) < 0) {
                propsFileName = System.getProperty("karaf.etc", "etc") + "/keystores/" + (String)propsFileName;
            }
            File propsFile = new File((String)propsFileName);
            try (FileInputStream is = new FileInputStream(propsFile);){
                props.load(is);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Exception caught loading external properties. ", ex);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Exception caught loading external properties. ", e);
        }
    }

    private void updateFromConfiguration(Properties props) {
        if (this.updatedPropertiesConfiguration == null) {
            return;
        }
        LOG.fine("Adding updated properties from configuration");
        try {
            this.updatedPropertiesConfiguration.update();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Exception caught re-loading OSGi configuration. ", e);
        }
        Dictionary cfgProps = this.updatedPropertiesConfiguration.getProperties();
        if (cfgProps != null) {
            Enumeration i = cfgProps.keys();
            while (i.hasMoreElements()) {
                String key = (String)i.nextElement();
                Object value = cfgProps.get(key);
                if (value == null) continue;
                props.put(key, value);
            }
        }
    }
}

