/*
 * Decompiled with CFR 0.152.
 */
package com.talend.compress.zip;

import com.talend.compress.zip.IntegrityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.crypto.CipherOutputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.compress.utils.IOUtils;

public class Zip {
    private String sourceFile;
    private String targetZip;
    private boolean overwriteExistTargetZip = true;
    private boolean makeTargetDir = false;
    private CompressionLevel compressLevel = CompressionLevel.MEDIUM_FAST;
    private String encoding = "ISO-8859-15";
    private boolean allFiles = true;
    private String namePatternFilter = null;
    private boolean containSubDir = true;
    private boolean isEncrypted = false;
    private String password = null;
    private String zip64Mode = null;
    private boolean useZip4jEncryption = false;
    private EncryptionMethod encryptionMethod = EncryptionMethod.AES;
    private AesKeyStrength aesKeyStrength = AesKeyStrength.KEY_STRENGTH_256;
    private String archiveFormat = "zip";
    private boolean syncFlush;
    private static final long ZIP64_MAGIC = 0xFFFFFFFFL;

    public void setUseZip4jEncryption(boolean useZip4jEncryption) {
        this.useZip4jEncryption = useZip4jEncryption;
    }

    public void setZip64Mode(String zip64Mode) {
        this.zip64Mode = zip64Mode;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public void setContainSubDir(boolean containSubDir) {
        this.containSubDir = containSubDir;
    }

    public void setAllFiles(boolean allFiles) {
        this.allFiles = allFiles;
    }

    public void setNamePatternFilter(String namePatternFilter) {
        this.namePatternFilter = namePatternFilter;
    }

    public void setCompressLevel(int compressLevel) {
        switch (compressLevel) {
            case 0: {
                this.compressLevel = CompressionLevel.NO_COMPRESSION;
                break;
            }
            case 4: {
                this.compressLevel = CompressionLevel.MEDIUM_FAST;
                break;
            }
            case 9: {
                this.compressLevel = CompressionLevel.ULTRA;
            }
        }
    }

    public void setMakeTargetDir(boolean makeTargetDir) {
        this.makeTargetDir = makeTargetDir;
    }

    public void setEncryptionMethod(String encryptionMethod) {
        this.encryptionMethod = EncryptionMethod.valueOf((String)encryptionMethod);
    }

    public void setAesKeyStrength(int aesKeyStrength) {
        this.aesKeyStrength = AesKeyStrength.getAesKeyStrengthFromRawCode((int)aesKeyStrength);
    }

    public String getArchiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public boolean isSyncFlush() {
        return this.syncFlush;
    }

    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }

    public Zip(String sourceFile, String targetZip) {
        this.sourceFile = sourceFile;
        this.targetZip = targetZip;
    }

    public void setOverwriteExistTargetZip(boolean overwriteExistTargetZip) {
        this.overwriteExistTargetZip = overwriteExistTargetZip;
    }

    public void checkTargetFilePath(String targetFilePath, boolean isOverwrite, boolean isMakeTargetDir) throws Exception {
        String targetDir;
        File zDir;
        File target = new File(this.targetZip);
        if (target.exists()) {
            if (!this.overwriteExistTargetZip) {
                throw new Exception("File already exist!");
            }
            target.delete();
        } else if (this.makeTargetDir && !(zDir = new File(targetDir = target.getParent())).exists()) {
            zDir.mkdirs();
        }
    }

    public void doZip() throws Exception {
        this.checkTargetFilePath(this.targetZip, this.overwriteExistTargetZip, this.makeTargetDir);
        File source = new File(this.sourceFile);
        final ArrayList<File> list = new ArrayList<File>();
        if (source.isFile()) {
            list.add(source);
        } else {
            source.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File file = new File(dir, name);
                    if (file.isFile()) {
                        if (Zip.this.allFiles || name.matches(Zip.this.namePatternFilter)) {
                            list.add(file);
                            return true;
                        }
                    } else if (Zip.this.containSubDir) {
                        file.listFiles(this);
                    }
                    return false;
                }
            });
        }
        if (list.size() < 1) {
            return;
        }
        if (this.isEncrypted && this.useZip4jEncryption) {
            this.doZip2(source, list);
        } else if ("gzip".equals(this.archiveFormat)) {
            this.doGZip();
        } else if ("tgz".equals(this.archiveFormat)) {
            HashMap<String, File> filesMap = new HashMap<String, File>();
            int folderPathLen = source.getAbsolutePath().length();
            for (File file : list) {
                filesMap.put(file.getAbsolutePath().substring(folderPathLen), file);
            }
            this.doTarGZip(filesMap);
        } else {
            this.doZip1(source, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTarGZip(Map<String, File> filesMap) throws Exception {
        File targetFile = new File(this.targetZip);
        targetFile.setLastModified(System.currentTimeMillis());
        FileOutputStream fos = new FileOutputStream(targetFile);
        boolean syncFlush = this.syncFlush;
        final int compressLevel = this.compressLevel.getLevel();
        TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(fos, syncFlush){
            {
                super(arg0, arg1);
                this.def.setLevel(compressLevel);
            }
        });
        taos.setBigNumberMode(1);
        taos.setLongFileMode(2);
        try {
            for (String relativeDir : filesMap.keySet()) {
                File file = filesMap.get(relativeDir);
                taos.putArchiveEntry(new TarArchiveEntry(file, relativeDir));
                try (FileInputStream is = new FileInputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)taos);
                    taos.closeArchiveEntry();
                }
            }
        }
        finally {
            taos.close();
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGZip() throws Exception {
        File srcFile = new File(this.sourceFile);
        File tarFile = new File(this.targetZip);
        if (!GzipUtils.getUncompressedFilename((String)tarFile.getName()).equals(srcFile.getName())) {
            System.err.println("WARNING: It is better that the gzip file change from \"" + tarFile.getName() + "\" to \"" + GzipUtils.getCompressedFilename((String)srcFile.getName()) + "\".");
        }
        FileInputStream input = new FileInputStream(srcFile);
        FileOutputStream out = new FileOutputStream(tarFile);
        try {
            boolean syncFlush = this.syncFlush;
            final int compressLevel = this.compressLevel.getLevel();
            try (GZIPOutputStream gcos = new GZIPOutputStream(out, syncFlush){
                {
                    super(arg0, arg1);
                    this.def.setLevel(compressLevel);
                }
            };){
                IOUtils.copy((InputStream)input, (OutputStream)gcos);
            }
        }
        finally {
            ((InputStream)input).close();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doZip1(File source, List<File> list) throws Exception {
        int beginIndex = source.getPath().length() + 1;
        OutputStream output_stream = null;
        try {
            output_stream = new FileOutputStream(this.targetZip);
            if (this.isEncrypted && !"".equals(this.password)) {
                output_stream = new CipherOutputStream(output_stream, IntegrityUtil.createCipher(1, this.password));
            }
        }
        catch (Exception e) {
            if (output_stream != null) {
                ((OutputStream)output_stream).close();
            }
            throw e;
        }
        ZipArchiveOutputStream out = null;
        out = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(output_stream));
        out.setLevel(this.compressLevel.getLevel());
        out.setEncoding(this.encoding);
        if ("ALWAYS".equals(this.zip64Mode)) {
            out.setUseZip64(Zip64Mode.Always);
        } else if ("NEVER".equals(this.zip64Mode)) {
            out.setUseZip64(Zip64Mode.Never);
        }
        try {
            for (int i = 0; i < list.size(); ++i) {
                File currentFile = list.get(i);
                ZipArchiveEntry entry = new ZipArchiveEntry(currentFile.getPath().substring(beginIndex));
                entry.setTime(currentFile.lastModified());
                long fileLength = currentFile.length();
                if (fileLength >= 0xFFFFFFFFL) {
                    entry.setSize(fileLength);
                }
                out.putArchiveEntry(entry);
                try (BufferedInputStream in = null;){
                    int readLen;
                    in = new BufferedInputStream(new FileInputStream(currentFile));
                    byte[] buf = new byte[1024];
                    while ((readLen = in.read(buf, 0, 1024)) != -1) {
                        out.write(buf, 0, readLen);
                    }
                }
                out.closeArchiveEntry();
                out.flush();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void doZip2(File source, List<File> list) throws Exception {
        ZipFile zipFile = new ZipFile(this.targetZip, this.password.toCharArray());
        if ("UTF-8".equalsIgnoreCase(this.encoding)) {
            this.encoding = "UTF8";
        }
        zipFile.setCharset(Charset.forName(this.encoding));
        ZipParameters params = new ZipParameters();
        params.setCompressionMethod(CompressionMethod.DEFLATE);
        params.setCompressionLevel(this.compressLevel);
        if (this.isEncrypted && !"".equals(this.password)) {
            params.setEncryptFiles(true);
            params.setEncryptionMethod(this.encryptionMethod);
            if (this.encryptionMethod == EncryptionMethod.AES) {
                params.setAesKeyStrength(this.aesKeyStrength);
            }
        }
        params.setDefaultFolderPath(source.getAbsoluteFile().getPath());
        zipFile.addFiles(list, params);
    }
}

