/*
 * Decompiled with CFR 0.152.
 */
package com.talend.compress.zip;

import com.talend.compress.zip.UnzippedFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Util {
    public List<UnzippedFile> unzippedFiles = new ArrayList<UnzippedFile>();
    private boolean extractPath = false;

    public Util(boolean extractPath) {
        this.extractPath = extractPath;
    }

    public void deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                this.deleteDir(new File(dir, children[i]));
            }
        }
        dir.delete();
    }

    public void repairDir(File dir) {
        File parentFile = dir.getParentFile();
        if (parentFile != null) {
            if (parentFile.exists() && parentFile.isFile()) {
                parentFile.delete();
            }
            this.repairDir(parentFile);
        }
    }

    public void checkDir(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                this.deleteDir(file);
            }
        } else {
            this.repairDir(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(String path, String fileName, InputStream is) throws Exception {
        File f = null;
        if (this.extractPath) {
            f = new File(path, fileName);
        } else {
            String tempName;
            int m = (tempName = fileName.replaceAll("\\\\", "/")).lastIndexOf(47);
            String shortName = tempName.substring(m != -1 ? m + 1 : 0);
            f = new File(path, shortName);
        }
        if (!f.getCanonicalPath().startsWith(new File(path).getCanonicalPath())) {
            throw new IOException("expanding " + f.getName() + " would create file outside of " + path);
        }
        this.checkDir(f);
        f.getParentFile().mkdirs();
        f.createNewFile();
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            int len = is.read(buffer, 0, 1024);
            while (len != -1) {
                fos.write(buffer, 0, len);
                len = is.read(buffer, 0, 1024);
            }
        }
        this.unzippedFiles.add(new UnzippedFile(f.getName(), f.getAbsolutePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(String path, String fileName, boolean isDirectory, InputStream is) throws Exception {
        File f = null;
        if (this.extractPath) {
            f = new File(path, fileName);
        } else {
            String tempName;
            int m = (tempName = fileName.replaceAll("\\\\", "/")).lastIndexOf(47);
            String shortName = tempName.substring(m != -1 ? m + 1 : 0);
            f = new File(path, shortName);
        }
        if (!f.getCanonicalPath().startsWith(new File(path).getCanonicalPath())) {
            throw new IOException("expanding " + f.getName() + " would create file outside of " + path);
        }
        if (isDirectory) {
            if (!f.exists()) {
                f.mkdirs();
            }
        } else {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            f.createNewFile();
            try (FilterOutputStream bos = null;){
                bos = new BufferedOutputStream(new FileOutputStream(f));
                byte[] buff = new byte[1024];
                int data = -1;
                while ((data = is.read(buff)) != -1) {
                    ((BufferedOutputStream)bos).write(buff, 0, data);
                }
            }
        }
        this.unzippedFiles.add(new UnzippedFile(f.getName(), f.getAbsolutePath()));
    }

    public String getEntryName(String fileEntry) {
        if (fileEntry != null && !fileEntry.equals("")) {
            for (int i = fileEntry.length() - 1; i > 0; --i) {
                if (fileEntry.charAt(i) != '/' && fileEntry.charAt(i) != '\\') continue;
                fileEntry = fileEntry.substring(i + 1, fileEntry.length());
                break;
            }
        }
        return fileEntry;
    }

    public void addUnzippedFiles(String path, String fileName) throws Exception {
        File f = new File(path, fileName);
        this.unzippedFiles.add(new UnzippedFile(f.getName(), f.getAbsolutePath()));
    }
}

