/*
 * Decompiled with CFR 0.152.
 */
package uniserv.cliserv.post;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uniserv.cliserv.GatewayInternalException;
import uniserv.cliserv.GenClient;
import uniserv.cliserv.NoSuchArgException;
import uniserv.cliserv.Uniresult;
import uniserv.cliserv.post.ErrorHandler;
import uniserv.cliserv.post.ListHandler;
import uniserv.cliserv.post.PostException;
import uniserv.cliserv.post.PostPreferences;
import uniserv.cliserv.post.ResultHandler;

public class PostClient
extends GenClient {
    public static final int UNI_SEL_GOBACK = -1;
    public static final int UNI_SEL_END = -2;
    public static final int UNI_SEL_STOP = -3;
    private String myLanguage = "D";
    private String myZip = "";
    private String myCity = "";
    private String myStreet = "";
    private String myRegion = "";
    private String myCityDistrict = "";
    private int myAddressQuality = 0;
    private int myWarningCode = 0;
    private PostPreferences preferences = new PostPreferences();

    public PostClient() {
    }

    public PostClient(String host, int port, String service) throws IOException, GatewayInternalException, PostException {
        super(1);
        Uniresult myUniresult = super.open(host, port, service);
        if (myUniresult.getRetType() != 0) {
            StringBuffer msg = new StringBuffer();
            super.getErrorMsg(myUniresult.getRetType(), myUniresult.getRetInfo(), this.myLanguage, msg);
            throw new PostException(msg.toString());
        }
    }

    public PostPreferences getPreferences() {
        return this.preferences;
    }

    public void setLanguage(String language) {
        if (language != null && (language.equals("D") || language.equals("E") || language.equals("F"))) {
            this.myLanguage = language;
            if (this.myLanguage.equals("D")) {
                super.setArg("par_language", "1");
            }
            if (this.myLanguage.equals("E")) {
                super.setArg("par_language", "2");
            }
            if (this.myLanguage.equals("F")) {
                super.setArg("par_language", "3");
            }
        }
    }

    public void setCountry(String country) {
        if (country != null && country.length() > 0) {
            super.setArg("in_country", country);
        }
    }

    public void setRegion(String region) {
        if (region != null && region.length() > 0) {
            super.setArg("in_state", region);
        }
    }

    public void setPoboxNo(String poboxNo) {
        if (poboxNo != null && poboxNo.length() > 0) {
            super.setArg("in_pobox_no", poboxNo);
        }
    }

    public void setBuildingName(String buildingName) {
        if (buildingName != null && buildingName.length() > 0) {
            super.setArg("in_build_name", buildingName);
        }
    }

    public void setOrganisation(String organization) {
        if (organization != null && organization.length() > 0) {
            super.setArg("in_organisation", organization);
        }
    }

    public void setZip(String zip) {
        if (zip != null && zip.length() > 0) {
            super.setArg("in_zip", zip);
        }
    }

    public void setCity(String city) {
        if (city != null && city.length() > 0) {
            super.setArg("in_city", city);
        }
    }

    public void setStreet(String street) {
        if (street != null && street.length() > 0) {
            super.setArg("in_str_hno", street);
        }
    }

    public int getAddressQuality() {
        return this.myAddressQuality;
    }

    public String getZip() {
        return this.myZip;
    }

    public String getCity() {
        return this.myCity;
    }

    public String getStreet() {
        return this.myStreet;
    }

    public String getRegion() {
        return this.myRegion;
    }

    public String getCityDistrict() {
        return this.myCityDistrict;
    }

    public int getWarningCode() {
        return this.myWarningCode;
    }

    public void checkAddress(ResultHandler result, ListHandler list, ErrorHandler error) throws IOException, GatewayInternalException, PostException {
        Uniresult myUniresult = super.execRequest("check_address");
        this.myZip = "";
        this.myCity = "";
        this.myStreet = "";
        this.myRegion = "";
        this.myCityDistrict = "";
        this.myAddressQuality = 0;
        this.myWarningCode = 0;
        while (myUniresult.getRetType() == 3) {
            int myInfo = myUniresult.getRetInfo();
            int myCount = myUniresult.getRetCount();
            Vector<String> listArgs = new Vector<String>();
            int columnCount = 0;
            String[] names = this.preferences.keys(myInfo);
            int i = 0;
            while (i < names.length) {
                if (this.preferences.get(names[i], myInfo)) {
                    listArgs.add(names[i]);
                    ++columnCount;
                }
                ++i;
            }
            String[][] data = new String[myCount][columnCount];
            String[] columnNames = new String[columnCount];
            try {
                int i2 = 0;
                while (i2 < myCount) {
                    Hashtable<String, String> listArgsValues = new Hashtable<String, String>();
                    super.getArg(listArgs, listArgsValues, i2);
                    int j = 0;
                    Enumeration<String> t = listArgs.elements();
                    while (t.hasMoreElements()) {
                        String arg = t.nextElement();
                        String value = listArgsValues.get(arg);
                        if (i2 == 0) {
                            columnNames[j] = arg;
                        }
                        data[i2][j++] = value;
                    }
                    ++i2;
                }
            }
            catch (NoSuchArgException e) {
                throw new PostException(e.getMessage());
            }
            int action = list.handleSelectionList(myInfo, data, columnNames);
            if (action >= 0) {
                super.setArg("in_select_pos", new Integer(action).toString());
            } else if (action == -1) {
                super.setArg("in_select_control", "1");
            } else if (action == -2) {
                super.setArg("in_select_control", "2");
            } else {
                return;
            }
            myUniresult = super.execRequest();
        }
        switch (myUniresult.getRetType()) {
            case 0: 
            case 2: {
                Hashtable<String, String> outArgsValues = new Hashtable<String, String>();
                Vector<String> outArgs = new Vector<String>();
                outArgs.add("out_res_post_cl");
                outArgs.add("out_res_city");
                outArgs.add("out_res_hno");
                outArgs.add("out_res_str");
                outArgs.add("out_res_zip");
                outArgs.add("out_res_pobox");
                outArgs.add("out_zip");
                outArgs.add("out_city");
                outArgs.add("out_str_hno");
                outArgs.add("out_region");
                outArgs.add("out_city_district");
                try {
                    super.getArg(outArgs, outArgsValues);
                }
                catch (NoSuchArgException e) {
                    throw new PostException(e.getMessage());
                }
                this.myZip = outArgsValues.get("out_zip");
                this.myCity = outArgsValues.get("out_city");
                this.myStreet = outArgsValues.get("out_str_hno");
                this.myRegion = outArgsValues.get("out_region");
                this.myCityDistrict = outArgsValues.get("out_city_district");
                String resCl = outArgsValues.get("out_res_post_cl");
                String resZip = outArgsValues.get("out_res_zip");
                String resCity = outArgsValues.get("out_res_city");
                String resStr = outArgsValues.get("out_res_str");
                String resHno = outArgsValues.get("out_res_hno");
                if (resCl.equals("1")) {
                    this.myAddressQuality = 1;
                }
                if (resCl.equals("2")) {
                    this.myAddressQuality = 2;
                }
                if (resCity.equals("C ") || resHno.equals("NF") || resStr.equals("C ") || resZip.equals("C ")) {
                    this.myAddressQuality = 3;
                }
                if (resCl.equals("3") || resCity.equals("SC") || resStr.equals("SC") || resHno.equals("SC")) {
                    this.myAddressQuality = 4;
                }
                if (resZip.equals("SC")) {
                    this.myAddressQuality = 5;
                }
                if (resStr.equals("NC") || resStr.equals("NP")) {
                    this.myAddressQuality = 6;
                }
                if (resStr.equals("NF")) {
                    this.myAddressQuality = 7;
                }
                if (resCl.equals("4") && resCity.equals("NF")) {
                    StringBuffer eMsg = new StringBuffer();
                    super.getErrorMsg(myUniresult.getRetType(), myUniresult.getRetInfo(), this.myLanguage, eMsg);
                    error.handleError(1, myUniresult.getRetInfo(), eMsg.toString());
                    break;
                }
                String warning = null;
                if (myUniresult.getRetType() == 2) {
                    StringBuffer msg = new StringBuffer();
                    this.myWarningCode = myUniresult.getRetInfo();
                    super.getErrorMsg(myUniresult.getRetType(), myUniresult.getRetInfo(), this.myLanguage, msg);
                    warning = msg.toString();
                }
                result.handleCorrectAddress(warning);
                break;
            }
            case 1: {
                StringBuffer eMsg = new StringBuffer();
                super.getErrorMsg(myUniresult.getRetType(), myUniresult.getRetInfo(), this.myLanguage, eMsg);
                switch (myUniresult.getRetInfo()) {
                    case 1005: 
                    case 1023: 
                    case 1050: {
                        throw new PostException(eMsg.toString());
                    }
                }
                error.handleError(myUniresult.getRetType(), myUniresult.getRetInfo(), eMsg.toString());
            }
        }
    }

    public void finish() throws IOException, GatewayInternalException {
        super.close();
    }
}

