/*
 * Decompiled with CFR 0.152.
 */
package uniserv.cliserv;

import java.io.IOException;
import java.io.Reader;

public class GatewayBufferedReader
extends Reader {
    Reader in;
    char[] buffer;
    int pos;
    int limit;
    int markPos = -1;
    static final int DEFAULT_BUFFER_SIZE = 8192;

    public GatewayBufferedReader(Reader in) {
        this(in, 8192);
    }

    public GatewayBufferedReader(Reader in, int size) {
        super((Object)in);
        if (size <= 0) {
            throw new IllegalArgumentException("Illegal buffer size: " + size);
        }
        this.in = in;
        this.buffer = new char[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.buffer = null;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) throws IOException {
        if (readLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit is negative");
        }
        Reader reader = this.in;
        synchronized (reader) {
            this.checkStatus();
            if (this.pos + readLimit > this.limit) {
                char[] old_buffer = this.buffer;
                int extraBuffSpace = 0;
                if (this.pos > this.limit) {
                    extraBuffSpace = 1;
                }
                if (readLimit + extraBuffSpace > this.limit) {
                    this.buffer = new char[readLimit + extraBuffSpace];
                }
                this.limit -= this.pos;
                if (this.limit >= 0) {
                    System.arraycopy(old_buffer, this.pos, this.buffer, 0, this.limit);
                    this.pos = 0;
                }
            }
            if (this.limit < 0) {
                this.pos = 1;
                this.markPos = 0;
                this.limit = 0;
            } else {
                this.markPos = this.pos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            this.checkStatus();
            if (this.markPos < 0) {
                throw new IOException("mark never set or invalidated");
            }
            if (this.limit > 0) {
                this.pos = this.markPos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            this.checkStatus();
            return this.pos < this.limit || this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buf, int offset, int count) throws IOException {
        if (offset < 0 || offset + count > buf.length || count < 0) {
            throw new IndexOutOfBoundsException();
        }
        Reader reader = this.in;
        synchronized (reader) {
            this.checkStatus();
            boolean retAtEndOfBuffer = false;
            int avail = this.limit - this.pos;
            if (count > avail) {
                if (avail > 0) {
                    count = avail;
                } else {
                    if (this.limit == this.buffer.length) {
                        this.markPos = -1;
                    }
                    if (this.pos > this.limit) {
                        retAtEndOfBuffer = true;
                        --this.pos;
                    }
                    if (this.markPos < 0) {
                        if (count >= this.buffer.length && !retAtEndOfBuffer) {
                            return this.in.read(buf, offset, count);
                        }
                        this.limit = 0;
                        this.pos = 0;
                    }
                    avail = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit);
                    if (retAtEndOfBuffer && avail > 0 && this.buffer[this.limit] == '\n') {
                        --avail;
                        ++this.limit;
                    }
                    if (avail < count) {
                        if (avail <= 0) {
                            return avail;
                        }
                        count = avail;
                    }
                    this.limit += avail;
                }
            }
            System.arraycopy(this.buffer, this.pos, buf, offset, count);
            this.pos += count;
            return count;
        }
    }

    private int fill() throws IOException {
        int count;
        this.checkStatus();
        boolean retAtEndOfBuffer = false;
        if (this.pos > this.limit) {
            retAtEndOfBuffer = true;
            --this.pos;
        }
        if (this.markPos >= 0 && this.limit == this.buffer.length) {
            this.markPos = -1;
        }
        if (this.markPos < 0) {
            this.limit = 0;
            this.pos = 0;
        }
        if ((count = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) > 0) {
            this.limit += count;
        }
        if (retAtEndOfBuffer && this.buffer[this.pos] == '\n') {
            --count;
            if (this.markPos == this.pos) {
                ++this.markPos;
            }
            ++this.pos;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            block4: {
                this.checkStatus();
                if (this.pos < this.limit || this.fill() > 0) break block4;
                return -1;
            }
            return this.buffer[this.pos++];
        }
    }

    private int lineEnd(int limit) {
        int i = this.pos;
        while (i < limit) {
            char ch = this.buffer[i];
            if (ch == '\n') break;
            ++i;
        }
        return i;
    }

    public String readLine() throws IOException {
        int i;
        this.checkStatus();
        if (this.pos > this.limit) {
            int ch = this.read();
            if (ch < 0) {
                return null;
            }
            if (ch != 10) {
                --this.pos;
            }
        }
        if ((i = this.lineEnd(this.limit)) < this.limit) {
            String str = String.valueOf(this.buffer, this.pos, i - this.pos);
            this.pos = i + 1;
            return str;
        }
        StringBuilder sbuf = new StringBuilder(200);
        sbuf.append(this.buffer, this.pos, i - this.pos);
        this.pos = i;
        boolean eof = false;
        while (true) {
            char ch;
            if (this.pos >= this.limit) {
                int count = this.fill();
                if (count >= 0) continue;
                eof = true;
                break;
            }
            if ((ch = this.buffer[this.pos++]) == '\n') break;
            i = this.lineEnd(this.limit);
            sbuf.append(this.buffer, this.pos - 1, i - (this.pos - 1));
            this.pos = i;
        }
        return sbuf.length() == 0 && eof ? null : sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long skip(long count) throws IOException {
        Reader reader = this.in;
        synchronized (reader) {
            int avail;
            this.checkStatus();
            if (count < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            if (count == 0L) {
                return 0L;
            }
            if (this.pos > this.limit) {
                if (this.read() < 0) {
                    return 0L;
                }
                --this.pos;
            }
            if (count < (long)(avail = this.limit - this.pos)) {
                this.pos = (int)((long)this.pos + count);
                return count;
            }
            this.pos = this.limit;
            long todo = count - (long)avail;
            if (todo > (long)this.buffer.length) {
                this.markPos = -1;
                todo -= this.in.skip(todo);
            } else {
                while (todo > 0L && (avail = this.fill()) > 0) {
                    if ((long)avail > todo) {
                        avail = (int)todo;
                    }
                    this.pos += avail;
                    todo -= (long)avail;
                }
            }
            return count - todo;
        }
    }

    private void checkStatus() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }
}

