/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.collections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class MapValueSorter {
    public List<Object> getMostFrequent(Map<Object, Long> map, int topN) {
        List<Object> sortedMap = this.sortMap(map, false);
        return this.getFirstElements(sortedMap, topN);
    }

    public List<Object> getLessFrequent(Map<Object, Long> map, int bottomN) {
        List<Object> sortedMap = this.sortMap(map, true);
        return this.getFirstElements(sortedMap, bottomN);
    }

    private List<Object> getFirstElements(List<Object> sortedMap, int bottomN) {
        ArrayList<Object> mostFrequent = new ArrayList<Object>();
        int i = 0;
        for (Object object : sortedMap) {
            mostFrequent.add(object);
            if (++i != bottomN) continue;
            break;
        }
        return mostFrequent;
    }

    public List<Object> sortMap(Map<Object, Long> map, boolean ascendingOrder) {
        Comparator<Object> cmp = ascendingOrder ? new AscByValueComparator(map) : new DescByValueComparator(map);
        ArrayList<Object> keySet = new ArrayList<Object>(map.keySet());
        Collections.sort(keySet, cmp);
        return keySet;
    }

    private static class DescByValueComparator
    implements Comparator<Object> {
        private Map<Object, Long> baseMap;

        public DescByValueComparator(Map<Object, Long> map) {
            this.baseMap = map;
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            Long value1 = this.baseMap.get(arg1);
            if (value1 == null) {
                return -1;
            }
            Long value0 = this.baseMap.get(arg0);
            return value1.compareTo(value0);
        }
    }

    private static class AscByValueComparator
    implements Comparator<Object> {
        private Map<Object, Long> baseMap;

        public AscByValueComparator(Map<Object, Long> map) {
            this.baseMap = map;
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            Long value0 = this.baseMap.get(arg0);
            if (value0 == null) {
                return -1;
            }
            Long value1 = this.baseMap.get(arg1);
            return value0.compareTo(value1);
        }
    }
}

