/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder.model;

import java.util.Arrays;
import java.util.List;

public enum ERuntimeError {
    FATAL("Error: A fatal exception has occurred", null, true),
    LAUNCHER("Error: Could not find or load main class org.eclipse.core.launcher.Main", null, true),
    LICENSE1("Fetch License From Administrator!", "Please set up a valid license for commandline first!", false),
    LICENSE2("java.lang.Exception: License is not found, or expired", null, true),
    APPLICATION("java.lang.IllegalStateException: Unable to acquire application service. Ensure that the org.eclipse.core.runtime bundle is resolved and started (see config.ini).", null, true),
    P2INSTALL("Installation failed.", null, true),
    CODEGEN("CI_MSG:EXIT", null, false);

    private String originalError;
    private String friendlyError;
    private boolean delay;

    private ERuntimeError(String error, String friendlyError, boolean delay) {
        this.originalError = error;
        this.friendlyError = friendlyError;
        this.delay = delay;
    }

    public static List<ERuntimeError> getErrorsForScriptRun() {
        return Arrays.asList(FATAL, LAUNCHER, APPLICATION, LICENSE1, LICENSE2, CODEGEN);
    }

    public static List<ERuntimeError> getErrorsForUpgradeCmdline() {
        return Arrays.asList(FATAL, LAUNCHER, APPLICATION, LICENSE1, LICENSE2, P2INSTALL);
    }

    public static List<ERuntimeError> getErrorsForP2Install() {
        return Arrays.asList(FATAL, LAUNCHER, APPLICATION, P2INSTALL);
    }

    public String getOriginalError() {
        return this.originalError;
    }

    public String getFriendlyError() {
        return this.friendlyError;
    }

    public boolean isDelay() {
        return this.delay;
    }
}

