/*
 * Decompiled with CFR 0.152.
 */
package org.talend.jobbuilder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.talend.ci.util.Utils;
import org.talend.jobbuilder.JobBuilder;
import org.talend.jobbuilder.Run;
import org.talend.jobbuilder.model.BundleInfo;
import org.talend.jobbuilder.model.EPlatform;
import org.talend.jobbuilder.model.ERuntimeError;
import org.talend.jobbuilder.model.Version;

class RunInstall
extends Run {
    private boolean isRemoteUpdatesite;
    private boolean preInstall;

    RunInstall(JobBuilder mojo) {
        super(mojo);
        this.isRemoteUpdatesite = mojo.p2Update != null && mojo.p2Update.toLowerCase().startsWith("http");
    }

    @Override
    Run.Result doRun() throws MojoExecutionException, MojoFailureException {
        try {
            this.cleanInstallation();
            Run.Result result = Run.Result.SUCCESS;
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"-----------------------------------------------------");
            this.logger.info((CharSequence)"Start to install Commandline...");
            this.initP2Plugins();
            result = this.resolveFromUpdateSite();
            this.logger.info((CharSequence)"");
            this.mojo.setupComponentNexusProperties();
            this.resolveEclipseProductFile();
            this.resolveLicense();
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"Commandline installation finished.");
            this.logger.info((CharSequence)"-----------------------------------------------------");
            return result;
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoFailureException("Commandline installation failed: ", (Throwable)e);
        }
    }

    @Override
    List<ERuntimeError> getErrorsToCheck() {
        return ERuntimeError.getErrorsForP2Install();
    }

    @Override
    String getApplication() {
        return "org.talend.p2.installer.app";
    }

    @Override
    File getExecDir() {
        return new File(this.mojo.p2InstallerPath);
    }

    @Override
    List<String> getExecutionCommand() throws MojoFailureException {
        ArrayList<String> commandList = new ArrayList<String>();
        String classpath = new File(this.mojo.p2InstallerPath).toPath().resolve("plugins").resolve("org.eclipse.equinox.launcher_1.6.600.v20231106-1826.jar").normalize().toString();
        commandList.add("java");
        this.initProxyParams(commandList);
        this.addAdditionalProperties(this.mojo.jvmArguments, commandList);
        this.addArrangedProperties("install", true, commandList);
        commandList.add("-Dci.mode=true");
        if (this.mojo.debug) {
            commandList.add("-Xdebug");
            commandList.add("-agentlib:jdwp=server=y,transport=dt_socket,suspend=y,address=*:9195");
        }
        commandList.add("-cp");
        commandList.add(classpath);
        commandList.add("org.eclipse.core.launcher.Main");
        commandList.add("-application");
        commandList.add(this.getApplication());
        commandList.add("-consolelog");
        if (!StringUtils.isEmpty(this.mojo.keyRingPath)) {
            commandList.add("-eclipse.keyring");
            commandList.add(this.mojo.keyRingPath);
        }
        if (!StringUtils.isEmpty(this.mojo.masterKeyPath)) {
            commandList.add("-eclipse.password");
            commandList.add(this.mojo.masterKeyPath);
        }
        if (!StringUtils.isEmpty(this.mojo.eclipseDebug)) {
            commandList.add("-debug");
            commandList.add(this.mojo.eclipseDebug);
        }
        commandList.add("-installIU");
        commandList.add(this.getIUsToInstall(this.preInstall));
        commandList.add("-repository");
        try {
            commandList.add(this.getRepositories());
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to get P2 repositories.", (Throwable)e);
        }
        commandList.add("-destination");
        commandList.add(this.getDestination(this.preInstall));
        commandList.add("-tag");
        commandList.add(this.getTag(this.preInstall));
        commandList.add("-profile");
        commandList.add("profile");
        commandList.add("-profileProperties");
        commandList.add("org.eclipse.update.install.features=true");
        commandList.add("-roaming");
        EPlatform platform = EPlatform.getPlatformInfo(this.mojo.targetOs);
        commandList.add("-p2.os");
        commandList.add(platform.getOs());
        commandList.add("-p2.ws");
        commandList.add(platform.getWs());
        return commandList;
    }

    private String getIUsToInstall(boolean preInstall) {
        return preInstall ? "org.talend.lite.p2.touchpoint.feature.feature.group" : "org.talend.studio.lite.ci.product,org.talend.lite.builtin.feature.feature.group,org.talend.lite.branding.feature.feature.group";
    }

    private String getDestination(boolean preInstall) {
        return new File(preInstall ? this.mojo.p2InstallerPath : this.mojo.productPath).toPath().normalize().toString();
    }

    private String getTag(boolean preInstall) {
        return preInstall ? "p2installer" : "cmdline";
    }

    private void resolveEclipseProductFile() throws Exception {
        File targetFile = new File(this.mojo.productPath).toPath().resolve(".eclipseproduct").toFile();
        if (targetFile.exists()) {
            return;
        }
        this.logger.info((CharSequence)"Resolve .eclipseproduct file...");
        Object source = this.isRemoteUpdatesite ? StringUtils.stripEnd(this.mojo.p2Update, "/") + "/.eclipseproduct" : new File(this.mojo.p2Update).toPath().resolve(".eclipseproduct").toString();
        this.mojo.transferFile(source, targetFile, this.mojo.getP2UserAndPwd(this.mojo.p2Update));
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(targetFile);){
            properties.load(in);
        }
        properties.setProperty("name", "Talend Commandline");
        properties.setProperty("id", "org.talend.studio.lite.ci.product");
        try {
            Collection<String> patches = this.mojo.getPreparedPatchesMap().values();
            if (patches != null && !patches.isEmpty()) {
                String latestVersion = this.getLatestPatchVersion();
                if (StringUtils.isBlank(latestVersion)) {
                    this.logger.error((Throwable)new Exception("No patch version defination found in patch"));
                } else {
                    properties.setProperty("version", latestVersion);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            properties.store(out, "");
        }
    }

    private void updateP2Cache() throws MojoFailureException, MojoExecutionException {
        String path = null;
        try {
            String latestPathVersion = this.getLatestPatchVersion();
            if (latestPathVersion != null) {
                path = this.mojo.getPreparedPatchesMap().get(latestPathVersion);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        if (path != null) {
            String contentJar = StringUtils.stripEnd(path, "/") + "/content.jar";
            File targetFile = new File(this.mojo.productPath, "configuration/talend/studioLite/metadata/updates/content.jar");
            if (targetFile.exists()) {
                targetFile.delete();
            }
            this.mojo.transferFile(contentJar, targetFile, this.mojo.getP2UserAndPwd(this.mojo.getOneP2UpdateUrl()));
        }
    }

    private String getLatestPatchVersion() throws Exception {
        Optional optional = this.mojo.getPreparedPatchesMap().keySet().stream().sorted((v1, v2) -> v2.compareTo((String)v1)).findFirst();
        if (optional.isPresent()) {
            return (String)optional.get();
        }
        return null;
    }

    private void resolveLicense() throws Exception {
        if (this.mojo.licensePath == null) {
            return;
        }
        File target = new File(this.mojo.productPath).toPath().resolve("license").toFile();
        if (target.exists()) {
            target.delete();
        }
        String[] userAndPwd = null;
        if (this.mojo.licenseUser != null && this.mojo.licensePassword != null) {
            userAndPwd = new String[]{this.mojo.licenseUser, this.mojo.decrypt("license.remote.password", this.mojo.licensePassword)};
        }
        this.logger.info((CharSequence)"Resolve license...");
        this.mojo.transferFile(this.mojo.licensePath, target, userAndPwd);
    }

    private File getLocalP2InstallerConfigFile() {
        return Paths.get(this.mojo.p2InstallerPath, new String[0]).resolve("configuration").resolve("config.ini").toFile();
    }

    private void initP2Plugins() throws Exception {
        if (this.getLocalP2InstallerConfigFile().exists()) {
            return;
        }
        this.logger.info((CharSequence)"");
        this.logger.info((CharSequence)"Init P2Installer plugins...");
        URL bundlesInfoURL = RunInstall.class.getClassLoader().getResource("org.talend.p2.installer.product/configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        List<BundleInfo> bundleList = null;
        try (InputStream in = bundlesInfoURL.openStream();){
            bundleList = IOUtils.readLines(bundlesInfoURL.openStream(), "UTF-8").stream().filter(line -> !line.startsWith("#")).map(BundleInfo::new).collect(Collectors.toList());
        }
        this.logger.info((CharSequence)"Get P2Installer plugins from updatesite...");
        String targetFolder = StringUtils.stripEnd(this.mojo.p2InstallerPath, "/") + "/plugins";
        String talendPrefix = "org.talend.";
        if (this.isRemoteUpdatesite) {
            String sourcePath = StringUtils.stripEnd(this.mojo.p2Update, "/") + "/plugins/";
            for (BundleInfo bundleInfo2 : bundleList) {
                String bundleId = bundleInfo2.getBundleId();
                if (bundleId.startsWith("org.talend.")) {
                    this.logger.info((CharSequence)("Already provided: " + bundleId + ", skip download of it."));
                    continue;
                }
                String bundleName = bundleId + "_" + bundleInfo2.getBundleVersion() + ".jar";
                String source = sourcePath + bundleName;
                File targetFile = new File(targetFolder).toPath().resolve(bundleName).toFile();
                this.mojo.transferFile(source, targetFile, this.mojo.getP2UserAndPwd(this.mojo.p2Update));
                bundleInfo2.setTargetLocation(targetFile);
            }
        } else {
            File sourcePath = new File(this.mojo.p2Update).toPath().resolve("plugins").toFile();
            for (BundleInfo bundleInfo3 : bundleList) {
                String bundleId = bundleInfo3.getBundleId();
                if (bundleId.startsWith("org.talend.")) {
                    this.logger.info((CharSequence)("Already provided: " + bundleId + ", skip download of it."));
                    continue;
                }
                String bundleName = bundleId + "_" + bundleInfo3.getBundleVersion() + ".jar";
                String source = sourcePath.toPath().resolve(bundleName).toString();
                File targetFile = new File(targetFolder).toPath().resolve(bundleName).toFile();
                this.mojo.transferFile(source, targetFile, this.mojo.getP2UserAndPwd(this.mojo.p2Update));
                bundleInfo3.setTargetLocation(targetFile);
            }
        }
        bundleList.forEach(bundleInfo -> {
            try {
                bundleInfo.unpack();
            }
            catch (Exception e) {
                this.logger.error((CharSequence)("Failed to unpack Bundle:" + bundleInfo.getBundleId()), (Throwable)e);
            }
        });
        this.logger.info((CharSequence)"Synchronize P2Installer configuration and p2 files...");
        Utils.copyFromJar("/org.talend.p2.installer.product", Paths.get(this.mojo.p2InstallerPath, new String[0]));
    }

    private boolean isCommandlineExist() {
        File configIniFile = new File(StringUtils.stripEnd(this.mojo.productPath, "/") + "/configuration/config.ini");
        return configIniFile.exists();
    }

    private Run.Result resolveFromUpdateSite() throws Exception {
        if (this.isCommandlineExist()) {
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"Found existing installation, skipping...");
            return Run.Result.SKIPPED;
        }
        this.updateP2Cache();
        this.preInstall = true;
        new Run.RuntimeExecutor(this).exec();
        this.preInstall = false;
        new Run.RuntimeExecutor(this).exec();
        return Run.Result.SUCCESS;
    }

    private String getRepositories() throws Exception {
        StringBuilder repositories = new StringBuilder();
        Collection<String> patches = this.mojo.getPreparedPatchesMap().values();
        if (patches != null && !patches.isEmpty()) {
            for (String path : patches) {
                repositories.append(Utils.formatUriStr(path));
                repositories.append(",");
            }
        }
        return StringUtils.removeEnd(repositories.toString(), ",");
    }

    private void cleanInstallation() {
        boolean needClean = this.mojo.installerClean;
        if (!needClean) {
            boolean isCompatible;
            boolean isCmdCompatible = true;
            boolean doesCommandlineExist = this.isCommandlineExist();
            boolean hasP2Update = StringUtils.isNotBlank(this.mojo.p2Update);
            if (doesCommandlineExist) {
                isCmdCompatible = this.isCmdCompatible();
            }
            if (!isCmdCompatible && hasP2Update) {
                this.logger.info((CharSequence)"Existing commandline is not compatible with the update, will clean it and install a new one.");
                needClean = true;
            }
            if (!needClean && !doesCommandlineExist && hasP2Update && !(isCompatible = this.checkExistingInstallerCompatibility())) {
                needClean = true;
                this.logger.info((CharSequence)"Incompatible p2 installer found, will clean it.");
            }
        }
        if (needClean) {
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"Cleaning up existing P2Installer and Commandline installation...");
            try {
                File p2InstallerDir;
                File productDir = new File(this.mojo.productPath);
                if (productDir.exists() && productDir.isDirectory()) {
                    FileUtils.cleanDirectory(productDir);
                }
                if ((p2InstallerDir = new File(this.mojo.p2InstallerPath)).exists() && p2InstallerDir.isDirectory()) {
                    FileUtils.cleanDirectory(p2InstallerDir);
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e);
            }
        }
    }

    private boolean isCmdCompatible() {
        File plugins = Paths.get(this.mojo.productPath, "plugins").toFile();
        File[] files = plugins.listFiles(f -> f.getName().startsWith("org.talend.commons.runtime_"));
        if (files == null || files.length != 1) {
            this.logger.error((CharSequence)"Bad existing installation.");
            return false;
        }
        File jar = files[0];
        if (jar.exists()) {
            boolean bl;
            JarFile jarFile = new JarFile(jar);
            try {
                JarEntry entry = jarFile.getJarEntry("talend.properties");
                Properties props = new Properties();
                try (InputStream in = jarFile.getInputStream(entry);){
                    props.load(in);
                }
                bl = "4.30.0".equals(props.getProperty("targetPlatformVersion")) && this.isCmdVersionCompatible();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.error((Throwable)e);
                }
            }
            jarFile.close();
            return bl;
        }
        return false;
    }

    private boolean isCmdVersionCompatible() {
        File eclipseProductFile = Paths.get(this.mojo.productPath, ".eclipseproduct").toFile();
        if (eclipseProductFile.exists()) {
            boolean bl;
            block9: {
                Properties props = new Properties();
                InputStream in = Files.newInputStream(eclipseProductFile.toPath(), new OpenOption[0]);
                try {
                    props.load(in);
                    String version = props.getProperty("version");
                    Version prodVersion = new Version(version);
                    boolean bl2 = bl = 0 < prodVersion.compareTo(new Version("8.0.1.20240701_1200-patch"));
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        this.logger.error(e);
                    }
                }
                in.close();
            }
            return bl;
        }
        return false;
    }

    private boolean checkExistingInstallerCompatibility() {
        boolean isCompatible = true;
        File localP2InstallerConfig = this.getLocalP2InstallerConfigFile();
        if (localP2InstallerConfig.exists()) {
            Properties existingConfigProps = new Properties();
            Properties newConfigProps = new Properties();
            try (InputStream existingConfigPropsStream = Files.newInputStream(localP2InstallerConfig.toPath(), StandardOpenOption.READ);){
                existingConfigProps.load(existingConfigPropsStream);
                newConfigProps.load(RunInstall.class.getResourceAsStream("/org.talend.p2.installer.product/configuration/config.ini"));
                String existingVerStr = existingConfigProps.getProperty("installer.version");
                if (StringUtils.isBlank(existingVerStr)) {
                    isCompatible = false;
                } else {
                    Version newVer;
                    Version existingVer;
                    String newVerStr = newConfigProps.getProperty("installer.version");
                    if (!StringUtils.equals(existingVerStr, newVerStr) && (existingVer = new Version(existingVerStr)).compareTo(newVer = new Version(newVerStr)) < 0) {
                        isCompatible = false;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((CharSequence)"Can't detect installer version", (Throwable)e);
            }
        }
        return isCompatible;
    }
}

