/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.sql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.talend.utils.format.StringFormatUtil;

public final class ResultSetUtils {
    private static final String NULLDATE = "0000-00-00 00:00:00";

    private ResultSetUtils() {
    }

    public static void printResultSet(ResultSet set, int width) throws SQLException {
        ResultSetMetaData metaData = set.getMetaData();
        int columnCount = metaData.getColumnCount();
        int minWidth = width;
        int i = 1;
        while (i <= columnCount) {
            minWidth = Math.max(minWidth, metaData.getColumnName(i).length());
            ++i;
        }
        String header = new String();
        int i2 = 1;
        while (i2 <= columnCount) {
            String columnName = StringFormatUtil.padString(metaData.getColumnName(i2), minWidth);
            header = String.valueOf(header) + columnName;
            ++i2;
        }
        System.out.println(header);
        String types = new String();
        int i3 = 1;
        while (i3 <= columnCount) {
            String columnTypeName = StringFormatUtil.padString(metaData.getColumnTypeName(i3), minWidth);
            types = String.valueOf(types) + columnTypeName;
            ++i3;
        }
        System.out.println(types);
        while (set.next()) {
            System.out.println(ResultSetUtils.formatRow(set, columnCount, minWidth));
        }
    }

    public static String formatRow(ResultSet set, int nbColumns, int width) throws SQLException {
        String row = new String();
        int i = 1;
        while (i <= nbColumns) {
            Object col = set.getObject(i);
            row = String.valueOf(row) + StringFormatUtil.padString(col != null ? col.toString() : "", width);
            ++i;
        }
        return row;
    }

    public static Object getBigObject(ResultSet set, int columnIndex) throws SQLException {
        Object object = null;
        try {
            object = set.getObject(columnIndex);
            if (object != null && object instanceof Clob) {
                Reader is = ((Clob)object).getCharacterStream();
                BufferedReader br = new BufferedReader(is);
                String str = br.readLine();
                StringBuffer sb = new StringBuffer();
                while (str != null) {
                    sb.append(str);
                    str = br.readLine();
                }
                return sb.toString();
            }
        }
        catch (SQLException e) {
            if (NULLDATE.equals(set.getString(columnIndex))) {
                object = null;
            }
            throw e;
        }
        catch (IOException iOException) {
            object = null;
        }
        return object;
    }

    public static Object getBigObject(ResultSet set, String columnName) throws SQLException {
        Object object = null;
        try {
            object = set.getObject(columnName);
            if (object != null && object instanceof Clob) {
                Reader is = ((Clob)object).getCharacterStream();
                BufferedReader br = new BufferedReader(is);
                String str = br.readLine();
                StringBuffer sb = new StringBuffer();
                while (str != null) {
                    sb.append(str);
                    str = br.readLine();
                }
                return sb.toString();
            }
        }
        catch (SQLException e) {
            if (NULLDATE.equals(set.getString(columnName))) {
                object = null;
            }
            throw e;
        }
        catch (IOException iOException) {
            object = null;
        }
        return object;
    }

    public static Object getObject(ResultSet set, int columnIndex) throws SQLException {
        Object object = null;
        try {
            object = set.getObject(columnIndex);
        }
        catch (SQLException e) {
            if (NULLDATE.equals(set.getString(columnIndex))) {
                object = null;
            }
            throw e;
        }
        return object;
    }

    public static Object getObject(ResultSet set, String columnName) throws SQLException {
        Object object = null;
        try {
            object = set.getObject(columnName);
        }
        catch (SQLException e) {
            if (NULLDATE.equals(set.getString(columnName))) {
                object = null;
            }
            throw e;
        }
        return object;
    }
}

