/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.jobconductor;

import java.util.Date;
import org.talend.utils.IdGenerator;
import org.talend.utils.jobconductor.TRIGGER_TYPE;

public final class TriggerNameHelper {
    private static final String P_TASK = "_task";
    public static final String PREFIX_TALEND_RECOVER_TRIGGER = "RecoverTrigger_task";
    public static final String PREFIX_QUARTZ_RECOVER_TRIGGER = "recover_";
    public static final String PREFIX_INSTANT_RUN_TRIGGER = "InstantRunTrigger";
    public static final String PREFIX_FILE_TRIGGER = "FileTrigger";
    private static final String PREFIX_TIME_TRIGGER = "";
    private static TriggerNameHelper instance;

    public static TriggerNameHelper getInstance() {
        if (instance == null) {
            instance = new TriggerNameHelper();
        }
        return instance;
    }

    private TriggerNameHelper() {
    }

    public Integer parseQuartzTriggerId(String triggerName) {
        String[] split = triggerName.split("\\.");
        if (this.isTalendRecoverTriggerName(triggerName = split[split.length - 1])) {
            String idStr = triggerName.substring(PREFIX_TALEND_RECOVER_TRIGGER.length());
            return Integer.parseInt(idStr);
        }
        if (this.isInstantRunTriggerName(triggerName)) {
            return null;
        }
        if (this.isFileTriggerName(triggerName)) {
            String idStr = triggerName.substring(PREFIX_FILE_TRIGGER.length());
            return Integer.parseInt(idStr);
        }
        try {
            return Integer.parseInt(triggerName);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.valueOf(triggerName) + " is not a valid trigger name");
        }
    }

    public int parseQuartzJobNameId(String quartzJobName) {
        try {
            String[] split = quartzJobName.split("\\.");
            quartzJobName = split[split.length - 1];
            if (quartzJobName.startsWith(TRIGGER_TYPE.getFileTriggerParentPrefix())) {
                String idStr = quartzJobName.substring(TRIGGER_TYPE.getFileTriggerParentPrefix().length());
                return Integer.parseInt(idStr);
            }
            return Integer.parseInt(quartzJobName);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.valueOf(quartzJobName) + " is not a valid job name");
        }
    }

    public boolean isInstantRunTriggerName(String triggerName) {
        return triggerName.matches(".*InstantRunTrigger.+");
    }

    public String buildRecoverTriggerName(int idTask) {
        return PREFIX_TALEND_RECOVER_TRIGGER + idTask;
    }

    public String buildInstantRunTriggerName(int idTask) {
        return new StringBuilder(PREFIX_INSTANT_RUN_TRIGGER).append(idTask).append("_").append(new Date().getTime()).append("_") + IdGenerator.getAsciiRandomString(5);
    }

    public String buildQuartzTriggerName(TRIGGER_TYPE triggerType, int talendTriggerId) {
        String quartzTriggerName = null;
        quartzTriggerName = triggerType == TRIGGER_TYPE.FILE_TRIGGER ? PREFIX_FILE_TRIGGER + talendTriggerId : String.valueOf(talendTriggerId);
        return quartzTriggerName;
    }

    public boolean isTalendRecoverTriggerName(String triggerName) {
        return triggerName.matches(".*RecoverTrigger_task.+");
    }

    public boolean isQuartzRecoverTriggerName(String triggerName) {
        return triggerName.matches("recover_.+");
    }

    public boolean isRecoverTriggerName(String triggerName) {
        return this.isTalendRecoverTriggerName(triggerName) || this.isQuartzRecoverTriggerName(triggerName);
    }

    public boolean isFileTriggerName(String triggerName) {
        return triggerName.matches(".*FileTrigger.+");
    }

    public boolean isTimeTriggerName(String triggerName) {
        return triggerName.matches("\\d+");
    }

    public boolean isTalendTriggerDependent(String quartzTriggerName) {
        return this.isTimeTriggerName(quartzTriggerName) || this.isFileTriggerName(quartzTriggerName);
    }
}

